/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.net;

import com.github.kokorin.jaffree.net.TcpNegotiator;
import com.github.kokorin.jaffree.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInputNegotiator
implements TcpNegotiator {
    private final InputStream source;
    private final int bufferSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInputNegotiator.class);

    public PipeInputNegotiator(InputStream source, int bufferSize) {
        this.source = source;
        this.bufferSize = bufferSize;
    }

    @Override
    public void negotiate(Socket socket) throws IOException {
        try (OutputStream destination = socket.getOutputStream();){
            IOUtil.copy(this.source, destination, this.bufferSize);
        }
        catch (SocketException e) {
            LOGGER.debug("Ignoring exception: " + e.getMessage());
        }
    }
}

