/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.protege.editor.owl.ui.renderer.LinkExtractor;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExBasedLinkExtractor
implements LinkExtractor {
    private static final Logger logger = LoggerFactory.getLogger(RegExBasedLinkExtractor.class);
    private final String name;
    private final Pattern linkPattern;
    private final String replacementString;

    public RegExBasedLinkExtractor(@Nonnull String name, @Nonnull Pattern linkPattern, @Nonnull String replacementString) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.linkPattern = (Pattern)Preconditions.checkNotNull((Object)linkPattern);
        this.replacementString = (String)Preconditions.checkNotNull((Object)replacementString);
    }

    public Optional<String> extractLinkLiteral(String s) {
        try {
            Matcher matcher = this.linkPattern.matcher(s);
            if (matcher.matches()) {
                String linkLexicalValue = matcher.replaceAll(this.replacementString);
                return Optional.of(linkLexicalValue);
            }
            return Optional.empty();
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn("Link extractor ({}) threw an IndexOutOfBoundsException: {}", (Object)this.name, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    @Nonnull
    public Optional<Link> extractLink(String s) {
        return this.extractLinkLiteral(s).flatMap(l -> {
            try {
                URI uri = new URI((String)l);
                return Optional.of(new HTTPLink(uri));
            }
            catch (URISyntaxException e) {
                logger.warn("Link extractor ({}) returned invalid URI: {}", (Object)this.name, (Object)e.getMessage());
                return Optional.empty();
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RegExBasedLinkExtractor").add("name", (Object)this.name).add("pattern", (Object)this.linkPattern.pattern()).add("replacement", (Object)this.replacementString).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.linkPattern, this.replacementString});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegExBasedLinkExtractor)) {
            return false;
        }
        RegExBasedLinkExtractor other = (RegExBasedLinkExtractor)obj;
        return this.name.equals(other.name) && this.linkPattern.equals(other.linkPattern) && this.replacementString.equals(other.replacementString);
    }
}

