import datetime

from ..core import WesternCalendar

class Canada(WesternCalendar): ...

class LateFamilyDayMixin:
    def get_family_day(self, year: int, label: str = "Family Day") -> tuple[datetime.date, str]: ...

class VictoriaDayMixin:
    def get_victoria_day(self, year: int) -> tuple[datetime.date, str] | None: ...

class AugustCivicHolidayMixin:
    def get_civic_holiday(self, year: int, label: str = "Civic Holiday") -> tuple[datetime.date, str]: ...

class ThanksgivingMixin:
    def get_thanksgiving(self, year: int) -> tuple[datetime.date, str]: ...

class BoxingDayMixin:
    def get_boxing_day(self, year: int) -> list[tuple[datetime.date, str]]: ...

class StJeanBaptisteMixin:
    def get_st_jean(self, year: int) -> list[tuple[datetime.date, str]]: ...

class RemembranceDayShiftMixin:
    def get_remembrance_day(self, year: int) -> list[tuple[datetime.date, str]]: ...

class Ontario(BoxingDayMixin, ThanksgivingMixin, VictoriaDayMixin, LateFamilyDayMixin, AugustCivicHolidayMixin, Canada): ...
class Quebec(VictoriaDayMixin, StJeanBaptisteMixin, ThanksgivingMixin, Canada): ...

class BritishColumbia(VictoriaDayMixin, AugustCivicHolidayMixin, ThanksgivingMixin, Canada):
    def get_family_day(self, year: int) -> tuple[datetime.date, str]: ...

class Alberta(LateFamilyDayMixin, VictoriaDayMixin, ThanksgivingMixin, Canada): ...
class Saskatchewan(
    LateFamilyDayMixin, VictoriaDayMixin, RemembranceDayShiftMixin, AugustCivicHolidayMixin, ThanksgivingMixin, Canada
): ...
class Manitoba(LateFamilyDayMixin, VictoriaDayMixin, AugustCivicHolidayMixin, ThanksgivingMixin, Canada): ...
class NewBrunswick(AugustCivicHolidayMixin, Canada): ...
class NovaScotia(RemembranceDayShiftMixin, LateFamilyDayMixin, Canada): ...
class PrinceEdwardIsland(LateFamilyDayMixin, RemembranceDayShiftMixin, Canada): ...
class Newfoundland(Canada): ...
class Yukon(VictoriaDayMixin, ThanksgivingMixin, Canada): ...
class NorthwestTerritories(RemembranceDayShiftMixin, VictoriaDayMixin, ThanksgivingMixin, Canada): ...
class Nunavut(VictoriaDayMixin, ThanksgivingMixin, RemembranceDayShiftMixin, Canada): ...
