/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PThreadLocal})
public final class ThreadLocalBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ThreadLocalBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ThreadLocalBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_setattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class SetattrNode
    extends TpSlotSetAttr.SetAttrBuiltinNode {
        @Specialization
        static void doStringKey(VirtualFrame frame, PThreadLocal object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached.Exclusive @Cached ObjectNodes.GenericSetAttrWithDictNode setAttrWithDictNode) {
            PDict localDict = getThreadLocalDict.execute(frame, object);
            setAttrWithDictNode.execute(inliningTarget, frame, object, key, value, localDict);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void doGeneric(VirtualFrame frame, PThreadLocal object, Object keyObject, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Exclusive @Cached ObjectNodes.GenericSetAttrWithDictNode setAttrWithDictNode) {
            PDict localDict = getThreadLocalDict.execute(frame, object);
            TruffleString key = ObjectNodes.GenericSetAttrNode.castAttributeKey(inliningTarget, keyObject, castKeyToStringNode, raiseNode);
            setAttrWithDictNode.execute(inliningTarget, frame, object, key, value, localDict);
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Node.Child
        private TpSlotDescrGet.CallSlotDescrGet callGetNode;

        @Specialization
        Object doIt(VirtualFrame frame, PThreadLocal object, Object keyObj, @Bind Node inliningTarget, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached GetClassNode getClassNode, @Cached TpSlots.GetObjectSlotsNode getDescrSlotsNode, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached HashingStorageNodes.HashingStorageGetItem getDictStorageItem, @Cached InlinedConditionProfile hasDescrProfile, @Cached InlinedConditionProfile hasDescrGetProfile, @Cached InlinedConditionProfile hasValueProfile, @Cached PRaiseNode raiseNode) {
            TpSlots descrSlots;
            TruffleString key;
            PDict localDict = getThreadLocalDict.execute(frame, object);
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(type, key);
            TpSlot descrGetSlot = null;
            boolean hasDescr = hasDescrProfile.profile(inliningTarget, descr != PNone.NO_VALUE);
            boolean hasDescrGet = false;
            if (hasDescr && (hasDescrGet = hasDescrGetProfile.profile(inliningTarget, (descrGetSlot = (descrSlots = getDescrSlotsNode.execute(inliningTarget, descr)).tp_descr_get()) != null)) && TpSlotDescrSet.PyDescr_IsData(descrSlots)) {
                return this.dispatch(frame, object, type, descr, descrGetSlot);
            }
            Object value = getDictStorageItem.execute((Frame)frame, inliningTarget, localDict.getDictStorage(), key);
            if (hasValueProfile.profile(inliningTarget, value != null)) {
                return value;
            }
            if (hasDescr) {
                if (!hasDescrGet) {
                    return descr;
                }
                return this.dispatch(frame, object, type, descr, descrGetSlot);
            }
            throw raiseNode.raiseAttributeError(inliningTarget, object, key);
        }

        private Object dispatch(VirtualFrame frame, Object object, Object type, Object descr, TpSlot get) {
            if (this.callGetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callGetNode = (TpSlotDescrGet.CallSlotDescrGet)this.insert(TpSlotDescrGet.CallSlotDescrGet.create());
            }
            return this.callGetNode.executeCached(frame, get, descr, object, type);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonUnaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        PDict repr(VirtualFrame frame, PThreadLocal self, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict) {
            return getThreadLocalDict.execute(frame, self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="_local", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ThreadLocalNode
    extends PythonBuiltinNode {
        @Specialization
        static PThreadLocal construct(Object cls, Object[] args, PKeyword[] keywordArgs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached PRaiseNode raiseNode, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            TpSlots slots;
            if ((args.length != 0 || keywordArgs.length != 0) && (slots = getSlots.execute(inliningTarget, cls)).tp_init() == ObjectBuiltins.SLOTS.tp_init()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INITIALIZATION_ARGUMENTS_ARE_NOT_SUPPORTED);
            }
            return PFactory.createThreadLocal(language, cls, getInstanceShape.execute(cls), args, keywordArgs);
        }
    }
}

