/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.builtins;

import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.method.PMethodBase;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.builtins.FunctionNodesFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public abstract class FunctionNodes {

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class GetCallTargetNode
    extends PNodeWithContext {
        public abstract RootCallTarget execute(Object var1);

        @Specialization
        static RootCallTarget doFunction(PFunction function, @Bind Node inliningTarget, @Cached.Shared(value="getCode") @Cached GetFunctionCodeNode getFunctionCodeNode, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt) {
            return getCt.execute(inliningTarget, getFunctionCodeNode.execute(inliningTarget, function));
        }

        @Specialization
        static RootCallTarget doBuiltinFunction(PBuiltinFunction builtinFunction) {
            return builtinFunction.getCallTarget();
        }

        @Specialization(guards={"isPFunction(function)"})
        static RootCallTarget doMethod(PMethod method, @Bind Node inliningTarget, @Bind(value="method.getFunction()") Object function, @Cached.Shared(value="getCode") @Cached GetFunctionCodeNode getFunctionCodeNode, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt) {
            return getCt.execute(inliningTarget, getFunctionCodeNode.execute(inliningTarget, (PFunction)function));
        }

        @Specialization(guards={"isPBuiltinFunction(method.getFunction())"})
        static RootCallTarget doMethod(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PBuiltinFunction)function).getCallTarget();
        }

        @Specialization
        static RootCallTarget doBuiltinMethod(PBuiltinMethod builtinMethod) {
            return builtinMethod.getBuiltinFunction().getCallTarget();
        }

        @Fallback
        static RootCallTarget fallback(Object callable) {
            return null;
        }

        public static GetCallTargetNode getUncached() {
            return FunctionNodesFactory.GetCallTargetNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetSignatureNode
    extends PNodeWithContext {
        public static Signature executeUncached(Object function) {
            return FunctionNodesFactory.GetSignatureNodeGen.getUncached().execute(null, function);
        }

        public abstract Signature execute(Node var1, Object var2);

        public abstract Signature execute(Node var1, PMethodBase var2);

        public static Signature getMethodSignatureSingleContext(PMethodBase method, Node inliningTarget) {
            CompilerAsserts.partialEvaluationConstant((Object)method);
            return GetSignatureNode.getFunctionSignatureSingleContext(inliningTarget, method.getFunction());
        }

        public static Signature getFunctionSignatureSingleContext(Node inliningTarget, Object fun) {
            CompilerAsserts.partialEvaluationConstant((Object)fun);
            if (fun instanceof PFunction) {
                PFunction f = (PFunction)fun;
                return CodeNodes.GetCodeSignatureNode.getInSingleContextMode(inliningTarget, f);
            }
            if (fun instanceof PBuiltinFunction) {
                PBuiltinFunction f = (PBuiltinFunction)fun;
                return f.getSignature();
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        static Signature doFunction(Node inliningTarget, PFunction function, @Cached.Shared(value="getSignature") @Cached CodeNodes.GetCodeSignatureNode getSignature) {
            return getSignature.execute(inliningTarget, function.getCode());
        }

        @Specialization
        static Signature doBuiltinFunction(PBuiltinFunction builtinFunction) {
            return builtinFunction.getSignature();
        }

        @Specialization(guards={"isPFunction(function)"})
        static Signature doMethod(Node inliningTarget, PMethod method, @Bind(value="method.getFunction()") Object function, @Cached.Shared(value="getSignature") @Cached CodeNodes.GetCodeSignatureNode getSignature) {
            return getSignature.execute(inliningTarget, ((PFunction)function).getCode());
        }

        @Specialization(guards={"isPBuiltinFunction(method.getFunction())"})
        static Signature doMethod(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PBuiltinFunction)function).getSignature();
        }

        @Specialization
        static Signature doBuiltinMethod(PBuiltinMethod builtinMethod) {
            return builtinMethod.getBuiltinFunction().getSignature();
        }

        public static GetSignatureNode getUncached() {
            return FunctionNodesFactory.GetSignatureNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetFunctionCodeNode
    extends PNodeWithContext {
        public abstract PCode execute(Node var1, PFunction var2);

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.getCodeStableAssumption()"}, limit="3")
        static PCode getCodeCached(PFunction self, @Cached(value="self") PFunction cachedSelf, @Cached(value="self.getCode()") PCode cachedCode) {
            return cachedCode;
        }

        @Specialization(replaces={"getCodeCached"})
        static PCode getCodeUncached(PFunction self) {
            return self.getCode();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetKeywordDefaultsNode
    extends PNodeWithContext {
        public abstract PKeyword[] execute(Node var1, Object var2);

        public abstract PKeyword[] execute(Node var1, PMethodBase var2);

        public static PKeyword[] getMethodKeywords(PMethodBase method) {
            CompilerAsserts.partialEvaluationConstant((Object)method);
            return GetKeywordDefaultsNode.getFunctionKeywords(method.getFunction());
        }

        public static PKeyword[] getFunctionKeywords(Object fun) {
            CompilerAsserts.partialEvaluationConstant((Object)fun);
            if (fun instanceof PFunction) {
                PFunction f = (PFunction)fun;
                return f.getKwDefaults();
            }
            if (fun instanceof PBuiltinFunction) {
                PBuiltinFunction f = (PBuiltinFunction)fun;
                return f.getKwDefaults();
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        static PKeyword[] doFunction(PFunction function) {
            return function.getKwDefaults();
        }

        @Specialization
        static PKeyword[] doBuiltinFunction(PBuiltinFunction builtinFunction) {
            return builtinFunction.getKwDefaults();
        }

        @Specialization(guards={"isPFunction(function)"})
        static PKeyword[] doMethod(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PFunction)function).getKwDefaults();
        }

        @Specialization(guards={"isPBuiltinFunction(method.getFunction())"})
        static PKeyword[] doMethodBuiltin(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PBuiltinFunction)function).getKwDefaults();
        }

        @Specialization
        static PKeyword[] doBuiltinMethod(PBuiltinMethod builtinMethod) {
            return builtinMethod.getBuiltinFunction().getKwDefaults();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetDefaultsNode
    extends PNodeWithContext {
        public abstract Object[] execute(Node var1, Object var2);

        public abstract Object[] execute(Node var1, PMethodBase var2);

        public static Object[] getMethodDefaults(PMethodBase method) {
            CompilerAsserts.partialEvaluationConstant((Object)method);
            return GetDefaultsNode.getFunctionDefaults(method.getFunction());
        }

        public static Object[] getFunctionDefaults(Object fun) {
            CompilerAsserts.partialEvaluationConstant((Object)fun);
            if (fun instanceof PFunction) {
                PFunction f = (PFunction)fun;
                return f.getDefaults();
            }
            if (fun instanceof PBuiltinFunction) {
                PBuiltinFunction f = (PBuiltinFunction)fun;
                return f.getDefaults();
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        static Object[] doFunction(PFunction function) {
            return function.getDefaults();
        }

        @Specialization
        static Object[] doBuiltinFunction(PBuiltinFunction builtinFunction) {
            return builtinFunction.getDefaults();
        }

        @Specialization(guards={"isPFunction(function)"})
        static Object[] doMethod(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PFunction)function).getDefaults();
        }

        @Specialization(guards={"isPBuiltinFunction(method.getFunction())"})
        static Object[] doMethodBuiltin(PMethod method, @Bind(value="method.getFunction()") Object function) {
            return ((PBuiltinFunction)function).getDefaults();
        }

        @Specialization
        static Object[] doBuiltinMethod(PBuiltinMethod builtinMethod) {
            return builtinMethod.getBuiltinFunction().getDefaults();
        }
    }
}

