/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.bib.Contributor;
import com.dickimawbooks.texparserlib.bib.ContributorFormat;

public class AbbrvContributorFormat
implements ContributorFormat {
    private String interInitials;
    private String sep;

    public AbbrvContributorFormat() {
        this(".", " ");
    }

    public AbbrvContributorFormat(String string, String string2) {
        this.interInitials = string;
        this.sep = string2;
    }

    public Object clone() {
        return new AbbrvContributorFormat(this.interInitials, this.sep);
    }

    public String getInitials(Contributor contributor) {
        String string = contributor.getForenames();
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\b(\\p{javaUpperCase})\\p{javaLowerCase}+", "$1" + this.interInitials);
    }

    @Override
    public String format(Contributor contributor) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getInitials(contributor);
        String string2 = contributor.getVonPart();
        String string3 = contributor.getSurname();
        String string4 = contributor.getSuffix();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (string2 != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(this.sep);
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(this.sep);
            }
            stringBuilder.append(string3);
        }
        if (string4 != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("," + this.sep);
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }
}

