/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;

public class LDAPTransaction
extends AbstractKeycloakTransaction {
    public static final Logger logger = Logger.getLogger(LDAPTransaction.class);
    private final LDAPStorageProvider ldapProvider;
    private final LDAPObject ldapUser;

    public LDAPTransaction(LDAPStorageProvider ldapProvider, LDAPObject ldapUser) {
        this.ldapProvider = ldapProvider;
        this.ldapUser = ldapUser;
    }

    protected void commitImpl() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transaction commit! Updating LDAP attributes for object " + this.ldapUser.getDn().toString() + ", attributes: " + this.ldapUser.getAttributes()));
        }
        this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
    }

    protected void rollbackImpl() {
        logger.warn((Object)("Transaction rollback! Ignoring LDAP updates for object " + this.ldapUser.getDn().toString()));
    }
}

