/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.yasson.internal.ReflectionUtils;

public class InstanceCreator {
    private final Map<Class, Creator> creators = new HashMap<Class, Creator>();

    public InstanceCreator() {
        this.creators.put(ArrayList.class, ArrayList::new);
        this.creators.put(LinkedList.class, LinkedList::new);
        this.creators.put(HashSet.class, HashSet::new);
        this.creators.put(TreeSet.class, TreeSet::new);
        this.creators.put(HashMap.class, HashMap::new);
        this.creators.put(TreeMap.class, TreeMap::new);
    }

    public <T> T createInstance(Class<T> tClass) {
        Creator creator = this.creators.get(tClass);
        if (creator == null) {
            creator = new ConstructorCreator(ReflectionUtils.getDefaultConstructor(tClass, true));
            this.creators.put(tClass, creator);
        }
        return (T)creator.createInstance();
    }

    private static final class ConstructorCreator
    implements Creator {
        private final Constructor<?> constructor;

        public ConstructorCreator(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object createInstance() {
            return ReflectionUtils.createNoArgConstructorInstance(this.constructor);
        }
    }

    private static interface Creator {
        public Object createInstance();
    }
}

