/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.deployers;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.ee.concurrent.ConcurrentContextInterceptor;
import org.jboss.as.ee.concurrent.ConcurrentContextSetupAction;
import org.jboss.as.ee.concurrent.handle.ClassLoaderContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.NamingContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.OtherEESetupActionsContextHandleFactory;
import org.jboss.as.ee.concurrent.service.ConcurrentContextService;
import org.jboss.as.ee.concurrent.service.ConcurrentServiceNames;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class EEConcurrentContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return;
        }
        this.processModuleDescription(eeModuleDescription, deploymentUnit, phaseContext);
        Collection<ComponentDescription> componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null) {
            return;
        }
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (componentDescription.getNamingMode() == ComponentNamingMode.NONE) continue;
            this.processComponentDescription(componentDescription);
        }
    }

    private void processModuleDescription(EEModuleDescription moduleDescription, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext) {
        ConcurrentContext concurrentContext = moduleDescription.getConcurrentContext();
        this.setupConcurrentContext(concurrentContext, moduleDescription.getApplicationName(), moduleDescription.getModuleName(), null, (ClassLoader)((Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader(), moduleDescription.getNamespaceContextSelector(), deploymentUnit, phaseContext.getServiceTarget());
        ConcurrentContextSetupAction setupAction = new ConcurrentContextSetupAction(concurrentContext);
        deploymentUnit.putAttachment(Attachments.CONCURRENT_CONTEXT_SETUP_ACTION, (Object)setupAction);
        deploymentUnit.addToAttachmentList(Attachments.WEB_SETUP_ACTIONS, (Object)setupAction);
    }

    private void processComponentDescription(ComponentDescription componentDescription) {
        ComponentConfigurator componentConfigurator = new ComponentConfigurator(){

            @Override
            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                ConcurrentContext concurrentContext = configuration.getConcurrentContext();
                EEConcurrentContextProcessor.this.setupConcurrentContext(concurrentContext, description.getApplicationName(), description.getModuleName(), description.getComponentName(), configuration.getModuleClassLoader(), configuration.getNamespaceContextSelector(), context.getDeploymentUnit(), context.getServiceTarget());
                ConcurrentContextInterceptor interceptor = new ConcurrentContextInterceptor(concurrentContext);
                ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)interceptor);
                configuration.addPostConstructInterceptor((InterceptorFactory)interceptorFactory, 384);
                configuration.addPreDestroyInterceptor((InterceptorFactory)interceptorFactory, 384);
                if (description.isPassivationApplicable()) {
                    configuration.addPrePassivateInterceptor((InterceptorFactory)interceptorFactory, 384);
                    configuration.addPostActivateInterceptor((InterceptorFactory)interceptorFactory, 384);
                }
                configuration.addComponentInterceptor((InterceptorFactory)interceptorFactory, 384, false);
            }
        };
        componentDescription.getConfigurators().add(componentConfigurator);
    }

    private void setupConcurrentContext(ConcurrentContext concurrentContext, String applicationName, String moduleName, String componentName, ClassLoader moduleClassLoader, NamespaceContextSelector namespaceContextSelector, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) {
        concurrentContext.addFactory(new NamingContextHandleFactory(namespaceContextSelector, deploymentUnit.getServiceName()));
        concurrentContext.addFactory(new ClassLoaderContextHandleFactory(moduleClassLoader));
        for (ContextHandleFactory factory : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_FACTORIES)) {
            concurrentContext.addFactory(factory);
        }
        concurrentContext.addFactory(new OtherEESetupActionsContextHandleFactory(deploymentUnit.getAttachmentList(Attachments.OTHER_EE_SETUP_ACTIONS)));
        ConcurrentContextService service = new ConcurrentContextService(concurrentContext);
        ServiceName serviceName = ConcurrentServiceNames.getConcurrentContextServiceName(applicationName, moduleName, componentName);
        serviceTarget.addService(serviceName, (Service)service).install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        deploymentUnit.removeAttachment(Attachments.CONCURRENT_CONTEXT_SETUP_ACTION);
        deploymentUnit.getAttachmentList(Attachments.WEB_SETUP_ACTIONS).removeIf(setupAction -> setupAction instanceof ConcurrentContextSetupAction);
    }
}

