/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;

public class InfinispanChangelogBasedTransaction<K, V extends SessionEntity>
extends AbstractKeycloakTransaction {
    public static final Logger logger = Logger.getLogger(InfinispanChangelogBasedTransaction.class);
    private final KeycloakSession kcSession;
    private final String cacheName;
    private final Cache<K, SessionEntityWrapper<V>> cache;
    private final RemoteCacheInvoker remoteCacheInvoker;
    private final Map<K, SessionUpdatesList<V>> updates = new HashMap<K, SessionUpdatesList<V>>();

    public InfinispanChangelogBasedTransaction(KeycloakSession kcSession, Cache<K, SessionEntityWrapper<V>> cache, RemoteCacheInvoker remoteCacheInvoker) {
        this.kcSession = kcSession;
        this.cacheName = cache.getName();
        this.cache = cache;
        this.remoteCacheInvoker = remoteCacheInvoker;
    }

    public void addTask(K key, SessionUpdateTask<V> task) {
        SessionUpdatesList<Object> myUpdates = this.updates.get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.cache.get(key);
            if (wrappedEntity == null) {
                logger.tracef("Not present cache item for key %s", key);
                return;
            }
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.updates.put(key, myUpdates);
        }
        task.runUpdate(myUpdates.getEntityWrapper().getEntity());
        myUpdates.add(task);
    }

    public void addTask(K key, SessionUpdateTask<V> task, V entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)entity).getRealmId());
        SessionEntityWrapper<V> wrappedEntity = new SessionEntityWrapper<V>(entity);
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity);
        this.updates.put(key, myUpdates);
        task.runUpdate(entity);
        myUpdates.add(task);
    }

    public void reloadEntityInCurrentTransaction(RealmModel realm, K key, SessionEntityWrapper<V> entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        SessionEntityWrapper latestEntity = (SessionEntityWrapper)this.cache.get(key);
        if (latestEntity == null) {
            return;
        }
        SessionUpdatesList newUpdates = new SessionUpdatesList(realm, latestEntity);
        SessionUpdatesList<V> existingUpdates = this.updates.get(key);
        if (existingUpdates != null) {
            newUpdates.setUpdateTasks(existingUpdates.getUpdateTasks());
        }
        this.updates.put(key, newUpdates);
    }

    public SessionEntityWrapper<V> get(K key) {
        SessionUpdatesList<Object> myUpdates = this.updates.get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.cache.get(key);
            if (wrappedEntity == null) {
                return null;
            }
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.updates.put(key, myUpdates);
            return wrappedEntity;
        }
        Object entity = myUpdates.getEntityWrapper().getEntity();
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().filter(task -> task.getOperation(entity) == SessionUpdateTask.CacheOperation.REMOVE).findFirst().isPresent();
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    protected void commitImpl() {
        for (Map.Entry<K, SessionUpdatesList<V>> entry : this.updates.entrySet()) {
            SessionUpdatesList<V> sessionUpdates = entry.getValue();
            SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
            RealmModel realm = sessionUpdates.getRealm();
            MergedUpdate merged = MergedUpdate.computeUpdate(sessionUpdates.getUpdateTasks(), sessionWrapper);
            if (merged == null) continue;
            this.runOperationInCluster(entry.getKey(), merged, sessionWrapper);
            this.remoteCacheInvoker.runTask(this.kcSession, realm, this.cacheName, entry.getKey(), merged, sessionWrapper);
        }
    }

    private void runOperationInCluster(K key, MergedUpdate<V> task, SessionEntityWrapper<V> sessionWrapper) {
        V session = sessionWrapper.getEntity();
        SessionUpdateTask.CacheOperation operation = task.getOperation(session);
        switch (operation) {
            case REMOVE: {
                CacheDecorators.skipCacheStore(this.cache).getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove(key);
                break;
            }
            case ADD: {
                CacheDecorators.skipCacheStore(this.cache).getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put(key, sessionWrapper, task.getLifespanMs(), TimeUnit.MILLISECONDS);
                break;
            }
            case ADD_IF_ABSENT: {
                SessionEntityWrapper existing = (SessionEntityWrapper)CacheDecorators.skipCacheStore(this.cache).putIfAbsent(key, sessionWrapper);
                if (existing == null) break;
                logger.debugf("Existing entity in cache for key: %s . Will update it", key);
                task.runUpdate(existing.getEntity());
                this.replace(key, task, existing);
                break;
            }
            case REPLACE: {
                this.replace(key, task, sessionWrapper);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state " + (Object)((Object)operation));
            }
        }
    }

    private void replace(K key, MergedUpdate<V> task, SessionEntityWrapper<V> oldVersionEntity) {
        boolean replaced = false;
        int iteration = 0;
        Object session = oldVersionEntity.getEntity();
        while (!replaced && iteration < 25) {
            ++iteration;
            SessionEntityWrapper<V> newVersionEntity = this.generateNewVersionAndWrapEntity(session, oldVersionEntity.getLocalMetadata());
            replaced = CacheDecorators.skipCacheStore(this.cache).replace(key, oldVersionEntity, newVersionEntity);
            if (!replaced) {
                if (logger.isDebugEnabled()) {
                    logger.debugf("Replace failed for entity: %s, old version %s, new version %s. Will try again", key, (Object)oldVersionEntity.getVersion(), (Object)newVersionEntity.getVersion());
                }
                if ((oldVersionEntity = (SessionEntityWrapper)this.cache.get(key)) == null) {
                    logger.debugf("Entity %s not found. Maybe removed in the meantime. Replace task will be ignored", key);
                    return;
                }
                session = oldVersionEntity.getEntity();
                task.runUpdate(session);
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.tracef("Replace SUCCESS for entity: %s . old version: %s, new version: %s", key, (Object)oldVersionEntity.getVersion(), (Object)newVersionEntity.getVersion());
        }
        if (!replaced) {
            logger.warnf("Failed to replace entity '%s' in cache '%s'", key, (Object)this.cache.getName());
        }
    }

    protected void rollbackImpl() {
    }

    private SessionEntityWrapper<V> generateNewVersionAndWrapEntity(V entity, Map<String, String> localMetadata) {
        return new SessionEntityWrapper<V>(localMetadata, entity);
    }
}

