/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.RealmModel;

public class LocaleBean {
    private String current;
    private String currentLanguageTag;
    private List<Locale> supported;

    public LocaleBean(RealmModel realm, java.util.Locale current, UriBuilder uriBuilder, Properties messages) {
        this.currentLanguageTag = current.toLanguageTag();
        this.current = messages.getProperty("locale_" + this.currentLanguageTag, this.currentLanguageTag);
        this.supported = new LinkedList<Locale>();
        for (String l : realm.getSupportedLocales()) {
            String label = messages.getProperty("locale_" + l, l);
            String url = uriBuilder.replaceQueryParam("kc_locale", new Object[]{l}).build(new Object[0]).toString();
            this.supported.add(new Locale(l, label, url));
        }
    }

    public String getCurrent() {
        return this.current;
    }

    public String getCurrentLanguageTag() {
        return this.currentLanguageTag;
    }

    public List<Locale> getSupported() {
        return this.supported;
    }

    public static class Locale {
        private String languageTag;
        private String label;
        private String url;

        public Locale(String languageTag, String label, String url) {
            this.languageTag = languageTag;
            this.label = label;
            this.url = url;
        }

        public String getLanguageTag() {
            return this.languageTag;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

