/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.PathValueOperation;
import com.google.common.base.Equivalence;

public final class TestOperation
extends PathValueOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    @JsonCreator
    public TestOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode tested = (JsonNode)this.path.path((TreeNode)node);
        if (tested.isMissingNode()) {
            throw new JsonPatchException("no such path in target JSON document");
        }
        if (!EQUIVALENCE.equivalent((Object)tested, (Object)this.value)) {
            throw new JsonPatchException("value differs from expectations");
        }
        return node.deepCopy();
    }

    @Override
    public String toString() {
        return "test: " + super.toString();
    }
}

