/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.lang3.SystemUtils;

public class PooledDatabaseConnection {
    private static PooledDatabaseConnection INSTANCE;
    private final HikariDataSource dataSource = this.setupDataSource();

    private PooledDatabaseConnection() {
    }

    public static PooledDatabaseConnection getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PooledDatabaseConnection();
        }
        return INSTANCE;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public static String getDatabaseLocation() {
        String strDatabase = Config.isPortableMode() ? Daten.getSettingsDirectory_String() + File.separator + "database" + File.separator : (SystemUtils.IS_OS_MAC_OSX ? GuiFunktionen.getHomePath() + File.separator + "Library/Caches/MediathekView/database" + File.separator : Daten.getSettingsDirectory_String() + File.separator + "database" + File.separator);
        Path filePath = Paths.get(strDatabase, new String[0]);
        Path absolutePath = filePath.toAbsolutePath();
        return absolutePath.toString();
    }

    private HikariDataSource setupDataSource() {
        String driverCommand = "jdbc:h2:file:" + PooledDatabaseConnection.getDatabaseLocation() + "mediathekview;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE;AUTO_RECONNECT=TRUE";
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
        config.addDataSourceProperty("URL", driverCommand);
        config.setMaximumPoolSize(Runtime.getRuntime().availableProcessors());
        return new HikariDataSource(config);
    }
}

