﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/ErrorDetails.h>
#include <aws/iottwinmaker/model/SyncResourceState.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {

/**
 * <p>The sync resource status.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/SyncResourceStatus">AWS
 * API Reference</a></p>
 */
class SyncResourceStatus {
 public:
  AWS_IOTTWINMAKER_API SyncResourceStatus() = default;
  AWS_IOTTWINMAKER_API SyncResourceStatus(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API SyncResourceStatus& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The sync resource status state.</p>
   */
  inline SyncResourceState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(SyncResourceState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline SyncResourceStatus& WithState(SyncResourceState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status error.</p>
   */
  inline const ErrorDetails& GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  template <typename ErrorT = ErrorDetails>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = ErrorDetails>
  SyncResourceStatus& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}
 private:
  SyncResourceState m_state{SyncResourceState::NOT_SET};

  ErrorDetails m_error;
  bool m_stateHasBeenSet = false;
  bool m_errorHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
