# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2022_03_01.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2022_03_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Pricing(Resource):
    """Microsoft Defender for Cloud is provided in two pricing tiers: free and standard, with the
    standard tier available with a trial period. The standard tier offers advanced security
    capabilities, while the free tier offers basic security features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar pricing_tier: The pricing tier value. Microsoft Defender for Cloud is provided in two
     pricing tiers: free and standard, with the standard tier available with a trial period. The
     standard tier offers advanced security capabilities, while the free tier offers basic security
     features. Known values are: "Free" and "Standard".
    :vartype pricing_tier: str or ~azure.mgmt.security.v2022_03_01.models.PricingTier
    :ivar sub_plan: The sub-plan selected for a Standard pricing configuration, when more than one
     sub-plan is available. Each sub-plan enables a set of security features. When not specified,
     full plan is applied.
    :vartype sub_plan: str
    :ivar free_trial_remaining_time: The duration left for the subscriptions free trial period - in
     ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
    :vartype free_trial_remaining_time: ~datetime.timedelta
    :ivar deprecated: Optional. True if the plan is deprecated. If there are replacing plans they
     will appear in ``replacedBy`` property.
    :vartype deprecated: bool
    :ivar replaced_by: Optional. List of plans that replace this plan. This property exists only if
     this plan is deprecated.
    :vartype replaced_by: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "free_trial_remaining_time": {"readonly": True},
        "deprecated": {"readonly": True},
        "replaced_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "pricing_tier": {"key": "properties.pricingTier", "type": "str"},
        "sub_plan": {"key": "properties.subPlan", "type": "str"},
        "free_trial_remaining_time": {"key": "properties.freeTrialRemainingTime", "type": "duration"},
        "deprecated": {"key": "properties.deprecated", "type": "bool"},
        "replaced_by": {"key": "properties.replacedBy", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        pricing_tier: Optional[Union[str, "_models.PricingTier"]] = None,
        sub_plan: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pricing_tier: The pricing tier value. Microsoft Defender for Cloud is provided in two
         pricing tiers: free and standard, with the standard tier available with a trial period. The
         standard tier offers advanced security capabilities, while the free tier offers basic security
         features. Known values are: "Free" and "Standard".
        :paramtype pricing_tier: str or ~azure.mgmt.security.v2022_03_01.models.PricingTier
        :keyword sub_plan: The sub-plan selected for a Standard pricing configuration, when more than
         one sub-plan is available. Each sub-plan enables a set of security features. When not
         specified, full plan is applied.
        :paramtype sub_plan: str
        """
        super().__init__(**kwargs)
        self.pricing_tier = pricing_tier
        self.sub_plan = sub_plan
        self.free_trial_remaining_time = None
        self.deprecated = None
        self.replaced_by = None


class PricingList(_serialization.Model):
    """List of pricing configurations response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of pricing configurations. Required.
    :vartype value: list[~azure.mgmt.security.v2022_03_01.models.Pricing]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Pricing]"},
    }

    def __init__(self, *, value: List["_models.Pricing"], **kwargs: Any) -> None:
        """
        :keyword value: List of pricing configurations. Required.
        :paramtype value: list[~azure.mgmt.security.v2022_03_01.models.Pricing]
        """
        super().__init__(**kwargs)
        self.value = value
