/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.collections.impl.VectorEnumerator;
import java.util.Enumeration;

public class Vector
implements Cloneable {
    protected Object[] data;
    protected int lastElement = -1;

    public Vector() {
        this(10);
    }

    public Vector(int n15) {
        this.data = new Object[n15];
    }

    public synchronized void appendElement(Object object) {
        this.ensureCapacity(this.lastElement + 2);
        this.data[++this.lastElement] = object;
    }

    public int capacity() {
        return this.data.length;
    }

    public Object clone() {
        Vector vector = null;
        try {
            vector = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("cannot clone Vector.super");
            return null;
        }
        vector.data = new Object[this.size()];
        System.arraycopy(this.data, 0, vector.data, 0, this.size());
        return vector;
    }

    public synchronized Object elementAt(int n15) {
        if (n15 >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(n15 + " >= " + this.data.length);
        }
        if (n15 < 0) {
            throw new ArrayIndexOutOfBoundsException(n15 + " < 0 ");
        }
        return this.data[n15];
    }

    public synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public synchronized void ensureCapacity(int n15) {
        if (n15 + 1 > this.data.length) {
            Object[] objectArray = this.data;
            int n16 = this.data.length * 2;
            if (n15 + 1 > n16) {
                n16 = n15 + 1;
            }
            this.data = new Object[n16];
            System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
        }
    }

    public synchronized boolean removeElement(Object object) {
        int n15;
        for (n15 = 0; n15 <= this.lastElement && this.data[n15] != object; ++n15) {
        }
        if (n15 <= this.lastElement) {
            this.data[n15] = null;
            int n16 = this.lastElement - n15;
            if (n16 > 0) {
                System.arraycopy(this.data, n15 + 1, this.data, n15, n16);
            }
            --this.lastElement;
            return true;
        }
        return false;
    }

    public synchronized void setElementAt(Object object, int n15) {
        if (n15 >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(n15 + " >= " + this.data.length);
        }
        this.data[n15] = object;
        if (n15 > this.lastElement) {
            this.lastElement = n15;
        }
    }

    public int size() {
        return this.lastElement + 1;
    }
}

