/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public class IfModelHandler
extends ModelHandlerBase {
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also https://logback.qos.ch/codes.html#ifJanino";
    public static final String NEW_OPERATOR_DISALLOWED_MSG = "The 'condition' attribute may not contain the 'new' operator.";
    public static final String NEW_OPERATOR_DISALLOWED_SEE = "See also https://logback.qos.ch/codes.html#conditionNew";
    public static final String CONDITION_ATTR_DEPRECATED_MSG = "The 'condition' attribute in <if> element is deprecated and slated for removal. Use <condition> element instead.";
    public static final String CONDITION_ATTR_DEPRECATED_SEE = "See also https://logback.qos.ch/codes.html#conditionAttributeDeprecation";
    IfModel ifModel = null;

    public IfModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic5) {
        return new IfModelHandler(context);
    }

    protected Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.ifModel = (IfModel)model;
        mic.pushModel(this.ifModel);
        Object micTopObject = mic.peekObject();
        String conditionStr = this.ifModel.getCondition();
        this.emitDeprecationWarningIfNecessary(conditionStr);
        if (micTopObject instanceof IfModel.BranchState) {
            IfModel.BranchState branchState = (IfModel.BranchState)((Object)micTopObject);
            this.ifModel.setBranchState(branchState);
            mic.popObject();
        } else {
            this.janinoFallback(mic, model, conditionStr);
        }
    }

    private void janinoFallback(ModelInterpretationContext mic, Model model, String conditionStr) {
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        Condition condition2 = null;
        int lineNum = model.getLineNumber();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(conditionStr)) {
            try {
                conditionStr = OptionHelper.substVars(conditionStr, mic, this.context);
            }
            catch (ScanException e15) {
                this.addError("Failed to parse input [" + conditionStr + "] on line " + lineNum, e15);
                this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
                return;
            }
            if (this.hasNew(conditionStr)) {
                this.addError(NEW_OPERATOR_DISALLOWED_MSG);
                this.addError(NEW_OPERATOR_DISALLOWED_SEE);
                return;
            }
            try {
                PropertyEvalScriptBuilder pesb = new PropertyEvalScriptBuilder(mic);
                pesb.setContext(this.context);
                condition2 = pesb.build(conditionStr);
            }
            catch (Exception | NoClassDefFoundError e16) {
                this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
                this.addError("Failed to parse condition [" + conditionStr + "] on line " + lineNum, e16);
                return;
            }
            if (condition2 != null) {
                boolean boolResult = condition2.evaluate();
                this.addInfo("Condition [" + conditionStr + "] evaluated to " + boolResult + " on line " + lineNum);
                this.ifModel.setBranchState(boolResult);
            } else {
                this.addError("The condition variable is null. This should not occur.");
                this.ifModel.setBranchState(IfModel.BranchState.IN_ERROR);
                return;
            }
        }
    }

    private void emitDeprecationWarningIfNecessary(String conditionStr) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(conditionStr)) {
            this.addWarn(CONDITION_ATTR_DEPRECATED_MSG);
            this.addWarn(CONDITION_ATTR_DEPRECATED_SEE);
        }
    }

    private boolean hasNew(String conditionStr) {
        return conditionStr.contains("new ");
    }

    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        if (mic.isModelStackEmpty()) {
            this.addError("Unexpected unexpected empty model stack.");
            return;
        }
        Model o15 = mic.peekModel();
        if (o15 != this.ifModel) {
            this.addWarn("The object [" + String.valueOf(o15) + "] on the top the of the stack is not the expected [" + String.valueOf(this.ifModel));
        } else {
            mic.popModel();
        }
    }

    static enum Branch {
        IF_BRANCH,
        ELSE_BRANCH;

    }
}

