/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.IdentityCompositeConverter;
import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import ch.qos.logback.core.pattern.parser.Compiler;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Parser<E>
extends ContextAwareBase {
    public static final String MISSING_RIGHT_PARENTHESIS = "https://logback.qos.ch/codes.html#missingRightParenthesis";
    public static final Map<String, Supplier<DynamicConverter>> DEFAULT_COMPOSITE_CONVERTER_MAP = new HashMap<String, Supplier<DynamicConverter>>();
    public static final String REPLACE_CONVERTER_WORD = "replace";
    final List<Token> tokenList;
    int pointer = 0;

    Parser(TokenStream ts4) throws ScanException {
        this.tokenList = ts4.tokenize();
    }

    public Parser(String pattern) throws ScanException {
        this(pattern, new RegularEscapeUtil());
    }

    public Parser(String pattern, IEscapeUtil escapeUtil) throws ScanException {
        try {
            TokenStream ts4 = new TokenStream(pattern, escapeUtil);
            this.tokenList = ts4.tokenize();
        }
        catch (IllegalArgumentException npe) {
            throw new ScanException("Failed to initialize Parser", npe);
        }
    }

    public Converter<E> compile(Node top, Map<String, Supplier<DynamicConverter>> converterMap) {
        Compiler compiler = new Compiler(top, converterMap);
        compiler.setContext(this.context);
        return compiler.compile();
    }

    public Node parse() throws ScanException {
        return this.E();
    }

    Node E() throws ScanException {
        Node t15 = this.T();
        if (t15 == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            t15.setNext(eOpt);
        }
        return t15;
    }

    Node Eopt() throws ScanException {
        Token next = this.getCurentToken();
        if (next == null) {
            return null;
        }
        return this.E();
    }

    Node T() throws ScanException {
        Token t15 = this.getCurentToken();
        this.expectNotNull(t15, "a LITERAL or '%'");
        switch (t15.getType()) {
            case 1000: {
                this.advanceTokenPointer();
                return new Node(0, t15.getValue());
            }
            case 37: {
                FormattingNode c15;
                this.advanceTokenPointer();
                Token u15 = this.getCurentToken();
                this.expectNotNull(u15, "a FORMAT_MODIFIER, SIMPLE_KEYWORD or COMPOUND_KEYWORD");
                if (u15.getType() == 1002) {
                    FormatInfo fi4 = FormatInfo.valueOf(u15.getValue());
                    this.advanceTokenPointer();
                    c15 = this.C();
                    c15.setFormatInfo(fi4);
                } else {
                    c15 = this.C();
                }
                return c15;
            }
        }
        return null;
    }

    FormattingNode C() throws ScanException {
        Token t15 = this.getCurentToken();
        this.expectNotNull(t15, "a LEFT_PARENTHESIS or KEYWORD");
        int type = t15.getType();
        switch (type) {
            case 1004: {
                return this.SINGLE();
            }
            case 1005: {
                this.advanceTokenPointer();
                return this.COMPOSITE(t15.getValue().toString());
            }
        }
        throw new IllegalStateException("Unexpected token " + String.valueOf(t15));
    }

    FormattingNode SINGLE() throws ScanException {
        Token t15 = this.getNextToken();
        SimpleKeywordNode keywordNode = new SimpleKeywordNode(t15.getValue());
        Token ot4 = this.getCurentToken();
        if (ot4 != null && ot4.getType() == 1006) {
            List<String> optionList = ot4.getOptionsList();
            keywordNode.setOptions(optionList);
            this.advanceTokenPointer();
        }
        return keywordNode;
    }

    FormattingNode COMPOSITE(String keyword) throws ScanException {
        CompositeNode compositeNode = new CompositeNode(keyword);
        Node childNode = this.E();
        compositeNode.setChildNode(childNode);
        Token t15 = this.getNextToken();
        if (t15 == null || t15.getType() != 41) {
            String msg = "Expecting RIGHT_PARENTHESIS token but got " + String.valueOf(t15);
            this.addError(msg);
            this.addError("See also https://logback.qos.ch/codes.html#missingRightParenthesis");
            throw new ScanException(msg);
        }
        Token ot4 = this.getCurentToken();
        if (ot4 != null && ot4.getType() == 1006) {
            List<String> optionList = ot4.getOptionsList();
            compositeNode.setOptions(optionList);
            this.advanceTokenPointer();
        }
        return compositeNode;
    }

    Token getNextToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer++);
        }
        return null;
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token t15, String expected) {
        if (t15 == null) {
            throw new IllegalStateException("All tokens consumed but was expecting " + expected);
        }
    }

    static {
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString(), IdentityCompositeConverter::new);
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(REPLACE_CONVERTER_WORD, ReplacingCompositeConverter::new);
    }
}

