/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.Dominators;
import com.android.dx.ssa.SetFactory;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntSet;
import java.util.ArrayList;
import java.util.BitSet;

public class DomFront {
    private static final boolean DEBUG = false;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> nodes;
    private final DomInfo[] domInfos;

    public DomFront(SsaMethod meth) {
        this.meth = meth;
        this.nodes = meth.getBlocks();
        int szNodes = this.nodes.size();
        this.domInfos = new DomInfo[szNodes];
        for (int i15 = 0; i15 < szNodes; ++i15) {
            this.domInfos[i15] = new DomInfo();
        }
    }

    public DomInfo[] run() {
        int szNodes = this.nodes.size();
        Dominators methDom = Dominators.make(this.meth, this.domInfos, false);
        this.buildDomTree();
        for (int i15 = 0; i15 < szNodes; ++i15) {
            this.domInfos[i15].dominanceFrontiers = SetFactory.makeDomFrontSet(szNodes);
        }
        this.calcDomFronts();
        return this.domInfos;
    }

    private void debugPrintDomChildren() {
        int szNodes = this.nodes.size();
        for (int i15 = 0; i15 < szNodes; ++i15) {
            SsaBasicBlock node = this.nodes.get(i15);
            StringBuffer sb5 = new StringBuffer();
            sb5.append('{');
            boolean comma = false;
            for (SsaBasicBlock child : node.getDomChildren()) {
                if (comma) {
                    sb5.append(',');
                }
                sb5.append(child);
                comma = true;
            }
            sb5.append('}');
            System.out.println("domChildren[" + node + "]: " + sb5);
        }
    }

    private void buildDomTree() {
        int szNodes = this.nodes.size();
        for (int i15 = 0; i15 < szNodes; ++i15) {
            DomInfo info = this.domInfos[i15];
            if (info.idom == -1) continue;
            SsaBasicBlock domParent = this.nodes.get(info.idom);
            domParent.addDomChild(this.nodes.get(i15));
        }
    }

    private void calcDomFronts() {
        int szNodes = this.nodes.size();
        for (int b15 = 0; b15 < szNodes; ++b15) {
            SsaBasicBlock nb5 = this.nodes.get(b15);
            DomInfo nbInfo = this.domInfos[b15];
            BitSet pred = nb5.getPredecessors();
            if (pred.cardinality() <= 1) continue;
            int i15 = pred.nextSetBit(0);
            while (i15 >= 0) {
                int runnerIndex = i15;
                while (runnerIndex != nbInfo.idom && runnerIndex != -1) {
                    DomInfo runnerInfo = this.domInfos[runnerIndex];
                    if (runnerInfo.dominanceFrontiers.has(b15)) break;
                    runnerInfo.dominanceFrontiers.add(b15);
                    runnerIndex = runnerInfo.idom;
                }
                i15 = pred.nextSetBit(i15 + 1);
            }
        }
    }

    public static class DomInfo {
        public IntSet dominanceFrontiers;
        public int idom = -1;
    }
}

