/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils.files;

import com.google.errorprone.annotations.MustBeClosed;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.WillCloseWhenClosed;

public final class BufferedIo {
    @MustBeClosed
    public static BufferedReader reader(@WillCloseWhenClosed InputStream is4) {
        return new BufferedReader(new InputStreamReader(is4, StandardCharsets.UTF_8));
    }

    @MustBeClosed
    public static BufferedReader reader(Path file2) throws IOException {
        return Files.newBufferedReader(file2, StandardCharsets.UTF_8);
    }

    @MustBeClosed
    public static InputStream inputStream(Path file2) throws IOException {
        return BufferedIo.makeBuffered(Files.newInputStream(file2, new OpenOption[0]));
    }

    @MustBeClosed
    public static OutputStream outputStream(Path file2) throws IOException {
        return BufferedIo.makeBuffered(Files.newOutputStream(file2, new OpenOption[0]));
    }

    @MustBeClosed
    static InputStream makeBuffered(@WillCloseWhenClosed InputStream is4) {
        return is4 instanceof BufferedInputStream || is4 instanceof ByteArrayInputStream ? is4 : new BufferedInputStream(is4);
    }

    @MustBeClosed
    static OutputStream makeBuffered(@WillCloseWhenClosed OutputStream os4) {
        return os4 instanceof BufferedOutputStream || os4 instanceof ByteArrayOutputStream ? os4 : new BufferedOutputStream(os4);
    }

    private BufferedIo() {
    }
}

