/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceGroupConfig;
import com.android.bundle.DeviceSelector;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DeviceGroupConfigValidator
extends SubValidator {
    private static final Pattern GROUP_NAME_REGEX = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");

    @Override
    public void validateBundle(AppBundle bundle) {
        bundle.getDeviceGroupConfig().ifPresent(DeviceGroupConfigValidator::validate);
    }

    private static void validate(DeviceGroupConfig deviceGroupConfig) {
        if (deviceGroupConfig.getDeviceGroupsList().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("The device group config must contain at least one device group.").build();
        }
        DeviceGroupConfigValidator.validateDeviceGroups(deviceGroupConfig.getDeviceGroupsList());
    }

    private static void validateDeviceGroups(List<DeviceGroup> deviceGroups) {
        deviceGroups.forEach(DeviceGroupConfigValidator::validateDeviceGroup);
        DeviceGroupConfigValidator.validateDeviceGroupNamesAreUnique(deviceGroups);
    }

    private static void validateDeviceGroupNamesAreUnique(List<DeviceGroup> deviceGroups) {
        ImmutableSet duplicateNames = deviceGroups.stream().map(DeviceGroup::getName).collect(CollectorUtils.groupingByDeterministic(Function.identity(), Collectors.counting())).entrySet().stream().filter(e15 -> (Long)e15.getValue() > 1L).map(e15 -> (String)e15.getKey()).collect(ImmutableSet.toImmutableSet());
        if (!duplicateNames.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Found duplicated device group names %s.", duplicateNames).build();
        }
    }

    private static void validateDeviceGroup(DeviceGroup deviceGroup) {
        DeviceGroupConfigValidator.validateDeviceGroupName(deviceGroup.getName());
        DeviceGroupConfigValidator.validateDeviceSelectors(deviceGroup.getDeviceSelectorsList(), deviceGroup.getName());
    }

    private static void validateDeviceGroupName(String deviceGroupName) {
        if (deviceGroupName.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Device groups must specify a name.").build();
        }
        if (!GROUP_NAME_REGEX.matcher(deviceGroupName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device group name should match the regex '%s', but found '%s'.", GROUP_NAME_REGEX, deviceGroupName).build();
        }
    }

    private static void validateDeviceSelectors(List<DeviceSelector> deviceSelectors, String groupName) {
        if (deviceSelectors.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Device group '%s' must specify at least one selector.", groupName).build();
        }
    }
}

