/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;

public class FlatCaret
extends DefaultCaret
implements UIResource {
    private static final String KEY_CARET_INFO = "FlatLaf.internal.caretInfo";
    private static final int NEVER = 0;
    private static final int ONCE = 1;
    private static final int ALWAYS = 2;
    private final String selectAllOnFocusPolicy;
    private final boolean selectAllOnMouseClick;
    private boolean inInstall;
    private boolean wasFocused;
    private boolean wasFocusTemporaryLost;
    private boolean isMousePressed;
    private boolean isWordSelection;
    private boolean isLineSelection;
    private int dragSelectionStart;
    private int dragSelectionEnd;

    public FlatCaret(String selectAllOnFocusPolicy, boolean selectAllOnMouseClick) {
        this.selectAllOnFocusPolicy = selectAllOnFocusPolicy;
        this.selectAllOnMouseClick = selectAllOnMouseClick;
    }

    @Override
    public void install(JTextComponent c15) {
        long[] ci4 = (long[])c15.getClientProperty(KEY_CARET_INFO);
        if (ci4 != null) {
            c15.putClientProperty(KEY_CARET_INFO, null);
            if (System.currentTimeMillis() - 500L > ci4[3]) {
                ci4 = null;
            }
        }
        if (ci4 != null) {
            this.setBlinkRate((int)ci4[2]);
        }
        this.inInstall = true;
        try {
            super.install(c15);
        }
        finally {
            this.inInstall = false;
        }
        if (ci4 != null) {
            this.select((int)ci4[1], (int)ci4[0]);
            if (ci4[4] != 0L) {
                this.wasFocused = true;
            }
            if (this.isSelectionVisible()) {
                EventQueue.invokeLater(() -> {
                    if (this.getComponent() == null) {
                        return;
                    }
                    if (this.isSelectionVisible()) {
                        this.setSelectionVisible(false);
                        this.setSelectionVisible(true);
                    }
                });
            }
        }
    }

    @Override
    public void deinstall(JTextComponent c15) {
        c15.putClientProperty(KEY_CARET_INFO, new long[]{this.getDot(), this.getMark(), this.getBlinkRate(), System.currentTimeMillis(), this.wasFocused ? 1L : 0L});
        super.deinstall(c15);
    }

    @Override
    protected void adjustVisibility(Rectangle nloc) {
        Rectangle r15;
        JTextComponent c15 = this.getComponent();
        if (c15 != null && c15.getUI() instanceof FlatTextFieldUI && (r15 = ((FlatTextFieldUI)c15.getUI()).getVisibleEditorRect()) != null) {
            nloc.x -= r15.x - c15.getInsets().left;
        }
        super.adjustVisibility(nloc);
    }

    @Override
    public void setDot(int dot) {
        super.setDot(dot);
        if (!this.wasFocused && this.getSelectAllOnFocusPolicy() == 1 && StackUtils.wasInvokedFrom(JTextComponent.class.getName(), "setCaretPosition", 6)) {
            this.wasFocused = true;
        }
    }

    @Override
    public void moveDot(int dot) {
        super.moveDot(dot);
        if (!this.wasFocused && this.getSelectAllOnFocusPolicy() == 1 && StackUtils.wasInvokedFrom(JTextComponent.class.getName(), "moveCaretPosition", 6)) {
            this.wasFocused = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e15) {
        if (!(this.inInstall || this.wasFocusTemporaryLost || this.isMousePressed && !this.isSelectAllOnMouseClick())) {
            this.selectAllOnFocusGained();
        }
        this.wasFocusTemporaryLost = false;
        this.wasFocused = true;
        super.focusGained(e15);
    }

    @Override
    public void focusLost(FocusEvent e15) {
        this.wasFocusTemporaryLost = e15.isTemporary();
        super.focusLost(e15);
    }

    @Override
    public void mousePressed(MouseEvent e15) {
        this.isMousePressed = true;
        super.mousePressed(e15);
        JTextComponent c15 = this.getComponent();
        this.isWordSelection = e15.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e15) && !e15.isConsumed();
        boolean bl4 = this.isLineSelection = e15.getClickCount() == 3 && SwingUtilities.isLeftMouseButton(e15) && (!e15.isConsumed() || c15.getDragEnabled());
        if (this.isLineSelection) {
            Action selectLineAction;
            ActionMap actionMap = c15.getActionMap();
            Action action = selectLineAction = actionMap != null ? actionMap.get("select-line") : null;
            if (selectLineAction != null) {
                selectLineAction.actionPerformed(new ActionEvent(c15, 1001, null, e15.getWhen(), e15.getModifiers()));
            }
        }
        if (this.isWordSelection || this.isLineSelection) {
            int mark = this.getMark();
            int dot = this.getDot();
            this.dragSelectionStart = Math.min(dot, mark);
            this.dragSelectionEnd = Math.max(dot, mark);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e15) {
        this.isMousePressed = false;
        this.isWordSelection = false;
        this.isLineSelection = false;
        super.mouseReleased(e15);
    }

    @Override
    public void mouseDragged(MouseEvent e15) {
        block7: {
            if ((this.isWordSelection || this.isLineSelection) && !e15.isConsumed() && SwingUtilities.isLeftMouseButton(e15)) {
                JTextComponent c15 = this.getComponent();
                int pos = c15.viewToModel(e15.getPoint());
                if (pos < 0) {
                    return;
                }
                try {
                    if (pos > this.dragSelectionEnd) {
                        this.select(this.dragSelectionStart, this.isWordSelection ? Utilities.getWordEnd(c15, pos) : Utilities.getRowEnd(c15, pos));
                        break block7;
                    }
                    if (pos < this.dragSelectionStart) {
                        this.select(this.dragSelectionEnd, this.isWordSelection ? Utilities.getWordStart(c15, pos) : Utilities.getRowStart(c15, pos));
                        break block7;
                    }
                    this.select(this.dragSelectionStart, this.dragSelectionEnd);
                }
                catch (BadLocationException ex4) {
                    UIManager.getLookAndFeel().provideErrorFeedback(c15);
                }
            } else {
                super.mouseDragged(e15);
            }
        }
    }

    protected void selectAllOnFocusGained() {
        JTextComponent c15 = this.getComponent();
        Document doc = c15.getDocument();
        if (doc == null || !c15.isEnabled() || !c15.isEditable() || FlatUIUtils.isCellEditor(c15)) {
            return;
        }
        int selectAllOnFocusPolicy = this.getSelectAllOnFocusPolicy();
        if (selectAllOnFocusPolicy == 0) {
            return;
        }
        if (selectAllOnFocusPolicy == 1 && !this.isMousePressed && this.wasFocused && !(c15 instanceof JFormattedTextField)) {
            return;
        }
        if (c15 instanceof JFormattedTextField) {
            EventQueue.invokeLater(() -> {
                JTextComponent c25 = this.getComponent();
                if (c25 == null) {
                    return;
                }
                this.select(0, c25.getDocument().getLength());
            });
        } else {
            this.select(0, doc.getLength());
        }
    }

    private void select(int mark, int dot) {
        if (mark != this.getMark()) {
            this.setDot(mark, Position.Bias.Forward);
        }
        if (dot != this.getDot()) {
            this.moveDot(dot, Position.Bias.Forward);
        }
    }

    private int getSelectAllOnFocusPolicy() {
        Object value = this.getClientProperty("JTextField.selectAllOnFocusPolicy");
        switch (String.valueOf(value instanceof String ? value : this.selectAllOnFocusPolicy)) {
            default: {
                return 0;
            }
            case "once": {
                return 1;
            }
            case "always": 
        }
        return 2;
    }

    private boolean isSelectAllOnMouseClick() {
        Object value = this.getClientProperty("JTextField.selectAllOnMouseClick");
        return value instanceof Boolean ? (Boolean)value : this.selectAllOnMouseClick;
    }

    private Object getClientProperty(String key) {
        JTextComponent c15 = this.getComponent();
        if (c15 == null) {
            return null;
        }
        Object value = c15.getClientProperty(key);
        if (value != null) {
            return value;
        }
        Container parent = c15.getParent();
        if (parent instanceof JComboBox) {
            return ((JComboBox)parent).getClientProperty(key);
        }
        if (parent instanceof JSpinner.DefaultEditor && (parent = parent.getParent()) instanceof JSpinner) {
            return ((JSpinner)parent).getClientProperty(key);
        }
        return null;
    }

    public void scrollCaretToVisible() {
        JTextComponent c15 = this.getComponent();
        if (c15 == null || c15.getUI() == null) {
            return;
        }
        try {
            Rectangle loc = c15.getUI().modelToView(c15, this.getDot(), this.getDotBias());
            if (loc != null) {
                this.adjustVisibility(loc);
                this.damage(loc);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

