/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class FlatToolBarSeparatorUI
extends BasicToolBarSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    private static final int LINE_WIDTH = 1;
    @FlatStylingSupport.Styleable
    protected int separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) ? FlatUIUtils.createSharedUI(FlatToolBarSeparatorUI.class, () -> new FlatToolBarSeparatorUI(true)) : new FlatToolBarSeparatorUI(false);
    }

    protected FlatToolBarSeparatorUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle((JSeparator)c15);
    }

    @Override
    protected void installDefaults(JSeparator c15) {
        super.installDefaults(c15);
        if (!this.defaults_initialized) {
            this.separatorWidth = UIManager.getInt("ToolBar.separatorWidth");
            this.separatorColor = UIManager.getColor("ToolBar.separatorColor");
            this.defaults_initialized = true;
        }
        c15.setAlignmentX(0.0f);
    }

    @Override
    protected void uninstallDefaults(JSeparator s15) {
        super.uninstallDefaults(s15);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator s15) {
        super.installListeners(s15);
        s15.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator s15) {
        super.uninstallListeners(s15);
        s15.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JSeparator s15 = (JSeparator)e15.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(s15)) {
                    s15.updateUI();
                } else {
                    this.installStyle(s15);
                }
                s15.revalidate();
                HiDPIUtils.repaint(s15);
            }
        }
    }

    protected void installStyle(JSeparator s15) {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(s15, "ToolBarSeparator"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        Dimension size = ((JToolBar.Separator)c15).getSeparatorSize();
        if (size != null) {
            return UIScale.scale(size);
        }
        int separatorWidth = this.separatorWidth;
        FlatToolBarUI toolBarUI = this.getToolBarUI(c15);
        if (toolBarUI != null && toolBarUI.separatorWidth != null) {
            separatorWidth = toolBarUI.separatorWidth;
        }
        int sepWidth = UIScale.scale((separatorWidth - 1) / 2) * 2 + UIScale.scale(1);
        boolean vertical = this.isVertical(c15);
        return new Dimension(vertical ? sepWidth : 0, vertical ? 0 : sepWidth);
    }

    @Override
    public Dimension getMaximumSize(JComponent c15) {
        Dimension size = this.getPreferredSize(c15);
        if (this.isVertical(c15)) {
            return new Dimension(size.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, size.height);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        int width = c15.getWidth();
        int height = c15.getHeight();
        float lineWidth = UIScale.scale(1.0f);
        float offset = UIScale.scale(2.0f);
        Color separatorColor = this.separatorColor;
        FlatToolBarUI toolBarUI = this.getToolBarUI(c15);
        if (toolBarUI != null && toolBarUI.separatorColor != null) {
            separatorColor = toolBarUI.separatorColor;
        }
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        g15.setColor(separatorColor);
        if (this.isVertical(c15)) {
            ((Graphics2D)g15).fill(new Rectangle2D.Float(Math.round(((float)width - lineWidth) / 2.0f), offset, lineWidth, (float)height - offset * 2.0f));
        } else {
            ((Graphics2D)g15).fill(new Rectangle2D.Float(offset, Math.round(((float)height - lineWidth) / 2.0f), (float)width - offset * 2.0f, lineWidth));
        }
        FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
    }

    private boolean isVertical(JComponent c15) {
        return ((JToolBar.Separator)c15).getOrientation() == 1;
    }

    private FlatToolBarUI getToolBarUI(JComponent c15) {
        Container parent = c15.getParent();
        return parent instanceof JToolBar && ((JToolBar)parent).getUI() instanceof FlatToolBarUI ? (FlatToolBarUI)((JToolBar)parent).getUI() : null;
    }
}

