/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatNativeLinuxLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class FlatWindowResizer
implements PropertyChangeListener,
ComponentListener {
    protected final JComponent resizeComp;
    protected final int borderDragThickness = FlatUIUtils.getUIInt("RootPane.borderDragThickness", 5);
    protected final int cornerDragWidth = FlatUIUtils.getUIInt("RootPane.cornerDragWidth", 16);
    protected final boolean honorFrameMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorFrameMinimumSizeOnResize");
    protected final boolean honorDialogMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorDialogMinimumSizeOnResize");
    protected final DragBorderComponent topDragComp;
    protected final DragBorderComponent bottomDragComp;
    protected final DragBorderComponent leftDragComp;
    protected final DragBorderComponent rightDragComp;

    protected FlatWindowResizer(JComponent resizeComp) {
        this.resizeComp = resizeComp;
        this.topDragComp = this.createDragBorderComponent(6, 8, 7);
        this.bottomDragComp = this.createDragBorderComponent(4, 9, 5);
        this.leftDragComp = this.createDragBorderComponent(6, 10, 4);
        this.rightDragComp = this.createDragBorderComponent(7, 11, 5);
        int insertIndex = resizeComp instanceof JRootPane ? 1 : 0;
        resizeComp.add((Component)this.topDragComp, insertIndex++);
        resizeComp.add((Component)this.bottomDragComp, insertIndex++);
        resizeComp.add((Component)this.leftDragComp, insertIndex++);
        resizeComp.add((Component)this.rightDragComp, insertIndex++);
        resizeComp.addComponentListener(this);
        resizeComp.addPropertyChangeListener("ancestor", this);
        if (resizeComp.isDisplayable()) {
            this.addNotify();
        }
    }

    protected DragBorderComponent createDragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
        return new DragBorderComponent(leadingResizeDir, centerResizeDir, trailingResizeDir);
    }

    public void uninstall() {
        this.removeNotify();
        this.resizeComp.removeComponentListener(this);
        this.resizeComp.removePropertyChangeListener("ancestor", this);
        this.resizeComp.remove(this.topDragComp);
        this.resizeComp.remove(this.bottomDragComp);
        this.resizeComp.remove(this.leftDragComp);
        this.resizeComp.remove(this.rightDragComp);
    }

    public void doLayout() {
        if (!this.topDragComp.isVisible()) {
            return;
        }
        int x15 = 0;
        int y15 = 0;
        int width = this.resizeComp.getWidth();
        int height = this.resizeComp.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Insets resizeInsets = this.getResizeInsets();
        int thickness = UIScale.scale(this.borderDragThickness);
        int topThickness = Math.max(resizeInsets.top, thickness);
        int bottomThickness = Math.max(resizeInsets.bottom, thickness);
        int leftThickness = Math.max(resizeInsets.left, thickness);
        int rightThickness = Math.max(resizeInsets.right, thickness);
        int y25 = y15 + topThickness;
        int height2 = height - topThickness - bottomThickness;
        this.topDragComp.setBounds(x15, y15, width, topThickness);
        this.bottomDragComp.setBounds(x15, y15 + height - bottomThickness, width, bottomThickness);
        this.leftDragComp.setBounds(x15, y25, leftThickness, height2);
        this.rightDragComp.setBounds(x15 + width - rightThickness, y25, rightThickness, height2);
        int cornerDelta = UIScale.scale(this.cornerDragWidth - this.borderDragThickness);
        this.topDragComp.setCornerDragWidths(leftThickness + cornerDelta, rightThickness + cornerDelta);
        this.bottomDragComp.setCornerDragWidths(leftThickness + cornerDelta, rightThickness + cornerDelta);
        this.leftDragComp.setCornerDragWidths(cornerDelta, cornerDelta);
        this.rightDragComp.setCornerDragWidths(cornerDelta, cornerDelta);
    }

    protected Insets getResizeInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected void addNotify() {
        this.updateVisibility();
    }

    protected void removeNotify() {
        this.updateVisibility();
    }

    protected void updateVisibility() {
        boolean visible = this.isWindowResizable();
        if (visible == this.topDragComp.isVisible()) {
            return;
        }
        this.topDragComp.setVisible(visible);
        this.bottomDragComp.setVisible(visible);
        this.leftDragComp.setVisible(visible);
        this.rightDragComp.setEnabled(visible);
        if (visible) {
            this.rightDragComp.setVisible(true);
            this.doLayout();
        } else {
            this.rightDragComp.setBounds(0, 0, 1, 1);
        }
    }

    boolean isDialog() {
        return false;
    }

    protected abstract boolean isWindowResizable();

    protected abstract Rectangle getWindowBounds();

    protected abstract void setWindowBounds(Rectangle var1);

    protected abstract boolean limitToParentBounds();

    protected abstract Rectangle getParentBounds();

    protected abstract boolean honorMinimumSizeOnResize();

    protected abstract boolean honorMaximumSizeOnResize();

    protected abstract Dimension getWindowMinimumSize();

    protected abstract Dimension getWindowMaximumSize();

    protected void beginResizing(int resizeDir, MouseEvent e15) {
    }

    protected void endResizing() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "ancestor": {
                if (e15.getNewValue() != null) {
                    this.addNotify();
                    break;
                }
                this.removeNotify();
                break;
            }
            case "resizable": {
                this.updateVisibility();
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e15) {
        this.doLayout();
    }

    @Override
    public void componentMoved(ComponentEvent e15) {
    }

    @Override
    public void componentShown(ComponentEvent e15) {
    }

    @Override
    public void componentHidden(ComponentEvent e15) {
    }

    protected class DragBorderComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private final int leadingResizeDir;
        private final int centerResizeDir;
        private final int trailingResizeDir;
        private int resizeDir = -1;
        private int leadingCornerDragWidth;
        private int trailingCornerDragWidth;
        private int dragLeftOffset;
        private int dragRightOffset;
        private int dragTopOffset;
        private int dragBottomOffset;

        protected DragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
            this.leadingResizeDir = leadingResizeDir;
            this.centerResizeDir = centerResizeDir;
            this.trailingResizeDir = trailingResizeDir;
            this.setResizeDir(centerResizeDir);
            this.setVisible(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        void setCornerDragWidths(int leading, int trailing) {
            this.leadingCornerDragWidth = leading;
            this.trailingCornerDragWidth = trailing;
        }

        protected void setResizeDir(int resizeDir) {
            if (this.resizeDir == resizeDir) {
                return;
            }
            this.resizeDir = resizeDir;
            this.setCursor(Cursor.getPredefinedCursor(resizeDir));
        }

        @Override
        public Dimension getPreferredSize() {
            int thickness = UIScale.scale(FlatWindowResizer.this.borderDragThickness);
            return new Dimension(thickness, thickness);
        }

        @Override
        protected void paintComponent(Graphics g15) {
            super.paintChildren(g15);
            FlatWindowResizer.this.updateVisibility();
        }

        @Override
        public void mouseClicked(MouseEvent e15) {
        }

        @Override
        public void mousePressed(MouseEvent e15) {
            if (!SwingUtilities.isLeftMouseButton(e15) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int xOnScreen = e15.getXOnScreen();
            int yOnScreen = e15.getYOnScreen();
            Rectangle windowBounds = FlatWindowResizer.this.getWindowBounds();
            this.dragLeftOffset = xOnScreen - windowBounds.x;
            this.dragTopOffset = yOnScreen - windowBounds.y;
            this.dragRightOffset = windowBounds.x + windowBounds.width - xOnScreen;
            this.dragBottomOffset = windowBounds.y + windowBounds.height - yOnScreen;
            FlatWindowResizer.this.beginResizing(this.resizeDir, e15);
        }

        @Override
        public void mouseReleased(MouseEvent e15) {
            if (!SwingUtilities.isLeftMouseButton(e15) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            this.dragBottomOffset = 0;
            this.dragTopOffset = 0;
            this.dragRightOffset = 0;
            this.dragLeftOffset = 0;
            FlatWindowResizer.this.endResizing();
        }

        @Override
        public void mouseEntered(MouseEvent e15) {
        }

        @Override
        public void mouseExited(MouseEvent e15) {
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            int wh4;
            boolean topOrBottom = this.centerResizeDir == 8 || this.centerResizeDir == 9;
            int xy4 = topOrBottom ? e15.getX() : e15.getY();
            int n15 = wh4 = topOrBottom ? this.getWidth() : this.getHeight();
            this.setResizeDir(xy4 <= this.leadingCornerDragWidth ? this.leadingResizeDir : (xy4 >= wh4 - this.trailingCornerDragWidth ? this.trailingResizeDir : this.centerResizeDir));
        }

        @Override
        public void mouseDragged(MouseEvent e15) {
            Dimension minimumSize;
            Rectangle parentBounds;
            if (!SwingUtilities.isLeftMouseButton(e15) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int xOnScreen = e15.getXOnScreen();
            int yOnScreen = e15.getYOnScreen();
            Rectangle oldBounds = FlatWindowResizer.this.getWindowBounds();
            Rectangle newBounds = new Rectangle(oldBounds);
            if (this.resizeDir == 8 || this.resizeDir == 6 || this.resizeDir == 7) {
                newBounds.y = yOnScreen - this.dragTopOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    newBounds.y = Math.max(newBounds.y, FlatWindowResizer.this.getParentBounds().y);
                }
                newBounds.height += oldBounds.y - newBounds.y;
            }
            if (this.resizeDir == 9 || this.resizeDir == 4 || this.resizeDir == 5) {
                newBounds.height = yOnScreen + this.dragBottomOffset - newBounds.y;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    parentBounds = FlatWindowResizer.this.getParentBounds();
                    int parentBottomY = parentBounds.y + parentBounds.height;
                    if (newBounds.y + newBounds.height > parentBottomY) {
                        newBounds.height = parentBottomY - newBounds.y;
                    }
                }
            }
            if (this.resizeDir == 10 || this.resizeDir == 6 || this.resizeDir == 4) {
                newBounds.x = xOnScreen - this.dragLeftOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    newBounds.x = Math.max(newBounds.x, FlatWindowResizer.this.getParentBounds().x);
                }
                newBounds.width += oldBounds.x - newBounds.x;
            }
            if (this.resizeDir == 11 || this.resizeDir == 7 || this.resizeDir == 5) {
                newBounds.width = xOnScreen + this.dragRightOffset - newBounds.x;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    parentBounds = FlatWindowResizer.this.getParentBounds();
                    int parentRightX = parentBounds.x + parentBounds.width;
                    if (newBounds.x + newBounds.width > parentRightX) {
                        newBounds.width = parentRightX - newBounds.x;
                    }
                }
            }
            Dimension dimension = minimumSize = FlatWindowResizer.this.honorMinimumSizeOnResize() ? FlatWindowResizer.this.getWindowMinimumSize() : null;
            if (minimumSize == null) {
                minimumSize = UIScale.scale(new Dimension(150, 50));
            }
            if (newBounds.width < minimumSize.width) {
                this.changeWidth(oldBounds, newBounds, minimumSize.width);
            }
            if (newBounds.height < minimumSize.height) {
                this.changeHeight(oldBounds, newBounds, minimumSize.height);
            }
            if (FlatWindowResizer.this.honorMaximumSizeOnResize()) {
                Dimension maximumSize = FlatWindowResizer.this.getWindowMaximumSize();
                if (newBounds.width > maximumSize.width) {
                    this.changeWidth(oldBounds, newBounds, maximumSize.width);
                }
                if (newBounds.height > maximumSize.height) {
                    this.changeHeight(oldBounds, newBounds, maximumSize.height);
                }
            }
            if (!newBounds.equals(oldBounds)) {
                FlatWindowResizer.this.setWindowBounds(newBounds);
            }
        }

        private void changeWidth(Rectangle oldBounds, Rectangle newBounds, int width) {
            if (newBounds.x != oldBounds.x) {
                newBounds.x -= width - newBounds.width;
            }
            newBounds.width = width;
        }

        private void changeHeight(Rectangle oldBounds, Rectangle newBounds, int height) {
            if (newBounds.y != oldBounds.y) {
                newBounds.y -= height - newBounds.height;
            }
            newBounds.height = height;
        }
    }

    public static class InternalFrameResizer
    extends FlatWindowResizer {
        protected final Supplier<DesktopManager> desktopManager;

        public InternalFrameResizer(JInternalFrame frame, Supplier<DesktopManager> desktopManager) {
            super(frame);
            this.desktopManager = desktopManager;
            frame.addPropertyChangeListener("resizable", this);
        }

        @Override
        public void uninstall() {
            this.getFrame().removePropertyChangeListener("resizable", this);
            super.uninstall();
        }

        private JInternalFrame getFrame() {
            return (JInternalFrame)this.resizeComp;
        }

        @Override
        protected Insets getResizeInsets() {
            return this.getFrame().getInsets();
        }

        @Override
        protected boolean isWindowResizable() {
            return this.getFrame().isResizable();
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.getFrame().getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle r15) {
            this.desktopManager.get().resizeFrame(this.getFrame(), r15.x, r15.y, r15.width, r15.height);
        }

        @Override
        protected boolean limitToParentBounds() {
            return true;
        }

        @Override
        protected Rectangle getParentBounds() {
            return new Rectangle(this.getFrame().getParent().getSize());
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return true;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return true;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.getFrame().getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.getFrame().getMaximumSize();
        }

        @Override
        protected void beginResizing(int resizeDir, MouseEvent e15) {
            int direction = 0;
            switch (resizeDir) {
                case 8: {
                    direction = 1;
                    break;
                }
                case 9: {
                    direction = 5;
                    break;
                }
                case 10: {
                    direction = 7;
                    break;
                }
                case 11: {
                    direction = 3;
                    break;
                }
                case 6: {
                    direction = 8;
                    break;
                }
                case 7: {
                    direction = 2;
                    break;
                }
                case 4: {
                    direction = 6;
                    break;
                }
                case 5: {
                    direction = 4;
                }
            }
            this.desktopManager.get().beginResizingFrame(this.getFrame(), direction);
        }

        @Override
        protected void endResizing() {
            this.desktopManager.get().endResizingFrame(this.getFrame());
        }
    }

    public static class WindowResizer
    extends FlatWindowResizer
    implements WindowStateListener {
        protected Window window;
        private final JComponent centerComp = new JPanel();
        private final boolean limitResizeToScreenBounds;

        public WindowResizer(JRootPane rootPane) {
            super(rootPane);
            this.centerComp.setOpaque(false);
            this.centerComp.setVisible(false);
            rootPane.add((Component)this.centerComp, 5);
            this.limitResizeToScreenBounds = SystemInfo.isLinux;
        }

        @Override
        public void uninstall() {
            this.resizeComp.remove(this.centerComp);
            super.uninstall();
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (this.centerComp != null && this.centerComp.isVisible()) {
                this.centerComp.setBounds(0, 0, this.resizeComp.getWidth(), this.resizeComp.getHeight());
            }
        }

        @Override
        protected void addNotify() {
            Container parent = this.resizeComp.getParent();
            Window window = this.window = parent instanceof Window ? (Window)parent : null;
            if (this.window instanceof Frame) {
                this.window.addPropertyChangeListener("resizable", this);
                this.window.addWindowStateListener(this);
            }
            super.addNotify();
        }

        @Override
        protected void removeNotify() {
            if (this.window instanceof Frame) {
                this.window.removePropertyChangeListener("resizable", this);
                this.window.removeWindowStateListener(this);
            }
            this.window = null;
            super.removeNotify();
        }

        @Override
        protected boolean isWindowResizable() {
            if (FlatUIUtils.isFullScreen(this.resizeComp)) {
                return false;
            }
            if (this.window instanceof Frame) {
                return ((Frame)this.window).isResizable() && (((Frame)this.window).getExtendedState() & 6) == 0;
            }
            if (this.window instanceof Dialog) {
                return ((Dialog)this.window).isResizable();
            }
            return false;
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.window.getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle r15) {
            this.window.setBounds(r15);
            this.doLayout();
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                this.window.validate();
                this.resizeComp.repaint();
            }
        }

        @Override
        protected boolean limitToParentBounds() {
            return this.limitResizeToScreenBounds && this.window != null && this.window.getGraphicsConfiguration() != null;
        }

        @Override
        protected Rectangle getParentBounds() {
            GraphicsConfiguration gc5 = this.window.getGraphicsConfiguration();
            Rectangle bounds = gc5.getBounds();
            Insets insets = FlatUIUtils.getScreenInsets(gc5);
            return new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return this.honorFrameMinimumSizeOnResize && this.window instanceof Frame || this.honorDialogMinimumSizeOnResize && this.window instanceof Dialog;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return false;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.window.getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.window.getMaximumSize();
        }

        @Override
        boolean isDialog() {
            return this.window instanceof Dialog;
        }

        @Override
        public void windowStateChanged(WindowEvent e15) {
            this.updateVisibility();
        }

        @Override
        protected void beginResizing(int resizeDir, MouseEvent e15) {
            if (SystemInfo.isLinux && this.window != null && FlatNativeLinuxLibrary.isWMUtilsSupported(this.window)) {
                int direction = -1;
                switch (resizeDir) {
                    case 8: {
                        direction = 1;
                        break;
                    }
                    case 9: {
                        direction = 5;
                        break;
                    }
                    case 10: {
                        direction = 7;
                        break;
                    }
                    case 11: {
                        direction = 3;
                        break;
                    }
                    case 6: {
                        direction = 0;
                        break;
                    }
                    case 7: {
                        direction = 2;
                        break;
                    }
                    case 4: {
                        direction = 6;
                        break;
                    }
                    case 5: {
                        direction = 4;
                    }
                }
                if (direction >= 0 && FlatNativeLinuxLibrary.moveOrResizeWindow(this.window, e15, direction)) {
                    return;
                }
            }
            this.centerComp.setBounds(0, 0, this.resizeComp.getWidth(), this.resizeComp.getHeight());
            this.centerComp.setCursor(Cursor.getPredefinedCursor(resizeDir));
            this.centerComp.setVisible(true);
        }

        @Override
        protected void endResizing() {
            this.centerComp.setVisible(false);
            this.centerComp.setCursor(null);
        }
    }
}

