/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.ColorInterpolation;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FeMergeNode;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitiveBase;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.impl.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.output.impl.GraphicsUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={FeMergeNode.class})
public final class FeMerge
extends ContainerNode
implements FilterPrimitive {
    public static final String TAG = "feMerge";
    private FilterPrimitiveBase filterPrimitiveBase;
    private FilterChannelKey[] inputChannels;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.filterPrimitiveBase = new FilterPrimitiveBase(attributeNode);
        List<FeMergeNode> nodes = this.childrenOfType(FeMergeNode.class);
        this.inputChannels = new FilterChannelKey[nodes.size()];
        for (int i15 = 0; i15 < this.inputChannels.length; ++i15) {
            this.inputChannels[i15] = nodes.get(i15).inputChannel();
        }
        this.children().clear();
    }

    @Override
    public boolean isValid() {
        return this.inputChannels.length > 0;
    }

    @Override
    @NotNull
    public Length x() {
        return this.filterPrimitiveBase.x;
    }

    @Override
    @NotNull
    public Length y() {
        return this.filterPrimitiveBase.y;
    }

    @Override
    @NotNull
    public Length width() {
        return this.filterPrimitiveBase.width;
    }

    @Override
    @NotNull
    public Length height() {
        return this.filterPrimitiveBase.height;
    }

    @Override
    public void layoutFilter(@NotNull RenderContext context, @NotNull FilterLayoutContext filterLayoutContext) {
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveLayoutResult(filterLayoutContext.resultChannels().get(DefaultFilterChannel.SourceGraphic), filterLayoutContext);
            return;
        }
        LayoutBounds result = filterLayoutContext.resultChannels().get(this.inputChannels[0]);
        for (int i15 = 1; i15 < this.inputChannels.length; ++i15) {
            LayoutBounds channelBounds = filterLayoutContext.resultChannels().get(this.inputChannels[i15]);
            result = result.union(channelBounds);
        }
        this.filterPrimitiveBase.saveLayoutResult(result, filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext context, @NotNull FilterContext filterContext) {
        Channel in4;
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveResult(this.filterPrimitiveBase.channel(DefaultFilterChannel.SourceGraphic, filterContext), filterContext);
            return;
        }
        Channel result = in4 = this.filterPrimitiveBase.channel(this.inputChannels[0], filterContext);
        if (this.inputChannels.length > 1) {
            BufferedImage dst = in4.toBufferedImageNonAliased(context);
            Graphics2D imgGraphics = GraphicsUtil.createGraphics(dst);
            for (int i15 = 1; i15 < this.inputChannels.length; ++i15) {
                Channel channel = this.filterPrimitiveBase.channel(this.inputChannels[i15], filterContext);
                imgGraphics.drawImage(context.platformSupport().createImage(channel.producer()), null, context.platformSupport().imageObserver());
            }
            result = new ImageProducerChannel(dst.getSource());
        }
        this.filterPrimitiveBase.saveResult(result, filterContext);
    }

    @Override
    public ColorInterpolation colorInterpolation(@NotNull FilterContext filterContext) {
        return this.filterPrimitiveBase.colorInterpolation(filterContext);
    }
}

