/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberLimits {
    private static final int MAX_NUMBER_STRING_LENGTH = 10000;

    private NumberLimits() {
    }

    private static void checkNumberStringLength(String s15) {
        if (s15.length() > 10000) {
            throw new NumberFormatException("Number string too large: " + s15.substring(0, 30) + "...");
        }
    }

    public static BigDecimal parseBigDecimal(String s15) throws NumberFormatException {
        NumberLimits.checkNumberStringLength(s15);
        BigDecimal decimal = new BigDecimal(s15);
        if (Math.abs((long)decimal.scale()) >= 10000L) {
            throw new NumberFormatException("Number has unsupported scale: " + s15);
        }
        return decimal;
    }

    public static BigInteger parseBigInteger(String s15) throws NumberFormatException {
        NumberLimits.checkNumberStringLength(s15);
        return new BigInteger(s15);
    }
}

