/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private int low;
    private float range;

    public GrayFilter() {
        this.canFilterIndexColorModel = true;
        this.low = 0;
        this.range = 1.0f;
    }

    public GrayFilter(float f15, float f16) {
        this.canFilterIndexColorModel = true;
        this.low = 0;
        this.range = 1.0f;
        if (f15 > f16) {
            f15 = 0.0f;
        }
        if (f15 < 0.0f) {
            f15 = 0.0f;
        } else if (f15 > 1.0f) {
            f15 = 1.0f;
        }
        if (f16 < 0.0f) {
            f16 = 0.0f;
        } else if (f16 > 1.0f) {
            f16 = 1.0f;
        }
        this.low = (int)(f15 * 255.0f);
        this.range = f16 - f15;
    }

    public GrayFilter(int n15, int n16) {
        this((float)n15 / 255.0f, (float)n16 / 255.0f);
    }

    @Override
    public int filterRGB(int n15, int n16, int n17) {
        int n18 = n17 >> 16 & 0xFF;
        int n19 = n17 >> 8 & 0xFF;
        int n25 = n17 & 0xFF;
        int n26 = (222 * n18 + 707 * n19 + 71 * n25) / 1000;
        if (this.range != 1.0f) {
            n26 = this.low + (int)((float)n26 * this.range);
        }
        return n17 & 0xFF000000 | n26 << 16 | n26 << 8 | n26;
    }
}

