/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.asm;

import java.util.HashMap;
import java.util.Map;

public enum HandleTag {
    GETFIELD(1, "get-field"),
    GETSTATIC(2, "get-static"),
    PUTFIELD(3, "put-field"),
    PUTSTATIC(4, "put-static"),
    INVOKEVIRTUAL(5, "invoke-virtual"),
    INVOKESTATIC(6, "invoke-static"),
    INVOKESPECIAL(7, "invoke-special"),
    NEWINVOKESPECIAL(8, "new-invoke-special"),
    INVOKEINTERFACE(9, "invoke-interface");

    private final int tag;
    private final String name;
    private static final HandleTag[] VALUES_ARRAY;
    private static final Map<String, HandleTag> NAMES_MAP;

    private HandleTag(int tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    public int getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public static HandleTag getByName(String name) {
        return NAMES_MAP.get(name);
    }

    public static HandleTag getByValue(int value) {
        return VALUES_ARRAY[value];
    }

    static {
        HandleTag[] values2 = HandleTag.values();
        HandleTag[] valuesArr = new HandleTag[10];
        HashMap<String, HandleTag> namesMap = new HashMap<String, HandleTag>(values2.length);
        HandleTag[] handleTagArray = values2;
        int n15 = handleTagArray.length;
        for (int i15 = 0; i15 < n15; ++i15) {
            HandleTag value;
            valuesArr[value.tag] = value = handleTagArray[i15];
            namesMap.put(value.name, value);
        }
        VALUES_ARRAY = valuesArr;
        NAMES_MAP = namesMap;
    }
}

