/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors;

import io.github.skylot.raung.common.AnnotationType;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.disasm.impl.utils.RaungTypes;
import io.github.skylot.raung.disasm.impl.utils.RaungWriter;
import io.github.skylot.raung.disasm.impl.utils.TypeRefUtils;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.TypePath;

public class RaungAnnotationVisitor
extends AnnotationVisitor {
    private final RaungClassVisitor clsVisitor;
    private final AnnotationType type;
    private final RaungWriter writer;

    public static RaungAnnotationVisitor buildAnnotation(RaungClassVisitor clsVisitor, String descriptor2, boolean visible) {
        RaungWriter writer = clsVisitor.getWriter();
        RaungAnnotationVisitor annotationVisitor = new RaungAnnotationVisitor(clsVisitor, writer, AnnotationType.NORMAL);
        writer.startLine(Directive.ANNOTATION).add(visible ? "runtime" : "build").space().add(descriptor2);
        writer.increaseIndent();
        return annotationVisitor;
    }

    public static AnnotationVisitor buildTypeAnnotation(RaungClassVisitor clsVisitor, int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        RaungWriter writer = clsVisitor.getWriter();
        RaungAnnotationVisitor annotationVisitor = new RaungAnnotationVisitor(clsVisitor, writer, AnnotationType.TYPE);
        writer.startLine(Directive.TYPE_ANNOTATION).add(visible ? "runtime" : "build").space().add(descriptor2);
        writer.increaseIndent();
        String ref = TypeRefUtils.formatPath(typeRef, typePath);
        if (!ref.isEmpty()) {
            writer.startLine(".ref").space().add(ref);
        }
        return annotationVisitor;
    }

    public static AnnotationVisitor buildParamAnnotation(RaungClassVisitor clsVisitor, int parameter, String descriptor2, boolean visible) {
        RaungWriter writer = clsVisitor.getWriter();
        RaungAnnotationVisitor av4 = new RaungAnnotationVisitor(clsVisitor, writer, AnnotationType.PARAM);
        writer.startLine(Directive.PARAM_ANNOTATION).add(parameter).space().add(visible ? "runtime" : "build").space().add(descriptor2);
        writer.increaseIndent();
        return av4;
    }

    public static AnnotationVisitor buildDefaultValueVisitor(RaungClassVisitor classVisitor) {
        RaungWriter writer = classVisitor.getWriter();
        RaungAnnotationVisitor av4 = new RaungAnnotationVisitor(classVisitor, writer, AnnotationType.DEFAULT);
        writer.startLine(Directive.ANNOTATION_DEFAULT_VALUE);
        writer.increaseIndent();
        return av4;
    }

    public static RaungAnnotationVisitor buildInsnAnnotation(RaungClassVisitor clsVisitor, RaungWriter writer, int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        RaungAnnotationVisitor annotationVisitor = new RaungAnnotationVisitor(clsVisitor, writer, AnnotationType.INSN);
        writer.startLine(Directive.INSN_ANNOTATION).add(visible ? "runtime" : "build").space().add(descriptor2);
        writer.increaseIndent();
        String ref = TypeRefUtils.formatPath(typeRef, typePath);
        if (!ref.isEmpty()) {
            writer.startLine(".ref").space().add(ref);
        }
        return annotationVisitor;
    }

    private RaungAnnotationVisitor(RaungClassVisitor clsVisitor, RaungWriter writer, AnnotationType type) {
        super(clsVisitor.getApi());
        this.clsVisitor = clsVisitor;
        this.writer = writer;
        this.type = type;
    }

    @Override
    public void visit(@Nullable String name, Object value) {
        this.startAssign(name).add(RaungTypes.format(value));
    }

    @Override
    public void visitEnum(@Nullable String name, String descriptor2, String value) {
        this.startAssign(name).add(Directive.ENUM).add(descriptor2).space().add(value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(@Nullable String name, String descriptor2) {
        this.startAssign(name).add('.').add(AnnotationType.SUB.getName()).space().add(descriptor2).increaseIndent();
        return new RaungAnnotationVisitor(this.clsVisitor, this.writer, AnnotationType.SUB);
    }

    @Override
    public AnnotationVisitor visitArray(@Nullable String name) {
        this.startAssign(name).add('.').add(AnnotationType.ARRAY.getName()).increaseIndent();
        return new RaungAnnotationVisitor(this.clsVisitor, this.writer, AnnotationType.ARRAY);
    }

    @Override
    public void visitEnd() {
        this.writer.decreaseIndent().startLine(".end ").add(this.type.getName());
    }

    private RaungWriter startAssign(String name) {
        this.writer.startLine();
        if (name != null) {
            this.writer.add(name).add(" = ");
        }
        return this.writer;
    }
}

