/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatArray<T>
extends Flowable<T> {
    final Publisher<? extends T>[] sources;
    final boolean delayError;

    public FlowableConcatArray(Publisher<? extends T>[] sources, boolean delayError) {
        this.sources = sources;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(this.sources, this.delayError, s15);
        s15.onSubscribe(parent);
        parent.onComplete();
    }

    static final class ConcatArraySubscriber<T>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -8158322871608889516L;
        final Subscriber<? super T> downstream;
        final Publisher<? extends T>[] sources;
        final boolean delayError;
        final AtomicInteger wip;
        int index;
        List<Throwable> errors;
        long produced;

        ConcatArraySubscriber(Publisher<? extends T>[] sources, boolean delayError, Subscriber<? super T> downstream) {
            super(false);
            this.downstream = downstream;
            this.sources = sources;
            this.delayError = delayError;
            this.wip = new AtomicInteger();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            this.setSubscription(s15);
        }

        @Override
        public void onNext(T t15) {
            ++this.produced;
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.delayError) {
                List<Throwable> list2 = this.errors;
                if (list2 == null) {
                    this.errors = list2 = new ArrayList<Throwable>(this.sources.length - this.index + 1);
                }
                list2.add(t15);
                this.onComplete();
            } else {
                this.downstream.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            block10: {
                if (this.wip.getAndIncrement() != 0) break block10;
                Publisher<? extends T>[] sources = this.sources;
                int n15 = sources.length;
                int i15 = this.index;
                while (true) {
                    if (i15 == n15) {
                        List<Throwable> list2 = this.errors;
                        if (list2 != null) {
                            if (list2.size() == 1) {
                                this.downstream.onError(list2.get(0));
                            } else {
                                this.downstream.onError(new CompositeException(list2));
                            }
                        } else {
                            this.downstream.onComplete();
                        }
                        return;
                    }
                    Publisher<T> p15 = sources[i15];
                    if (p15 == null) {
                        NullPointerException ex4 = new NullPointerException("A Publisher entry is null");
                        if (this.delayError) {
                            List<Throwable> list3 = this.errors;
                            if (list3 == null) {
                                this.errors = list3 = new ArrayList<Throwable>(n15 - i15 + 1);
                            }
                            list3.add(ex4);
                            ++i15;
                            continue;
                        }
                        this.downstream.onError(ex4);
                        return;
                    }
                    long r15 = this.produced;
                    if (r15 != 0L) {
                        this.produced = 0L;
                        this.produced(r15);
                    }
                    p15.subscribe(this);
                    this.index = ++i15;
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }
}

