/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDoFinally<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Action onFinally;

    public FlowableDoFinally(Flowable<T> source, Action onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoFinallyConditionalSubscriber((ConditionalSubscriber)s15, this.onFinally));
        } else {
            this.source.subscribe(new DoFinallySubscriber<T>(s15, this.onFinally));
        }
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements ConditionalSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final ConditionalSubscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallyConditionalSubscriber(ConditionalSubscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s15;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public boolean tryOnNext(T t15) {
            return this.downstream.tryOnNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs4 = this.qs;
            if (qs4 != null && (mode & 4) == 0) {
                int m15 = qs4.requestFusion(mode);
                if (m15 != 0) {
                    this.syncFused = m15 == 1;
                }
                return m15;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.qs.poll();
            if (v15 == null && this.syncFused) {
                this.runFinally();
            }
            return v15;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    RxJavaPlugins.onError(ex4);
                }
            }
        }
    }

    static final class DoFinallySubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final Subscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallySubscriber(Subscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s15;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs4 = this.qs;
            if (qs4 != null && (mode & 4) == 0) {
                int m15 = qs4.requestFusion(mode);
                if (m15 != 0) {
                    this.syncFused = m15 == 1;
                }
                return m15;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.qs.poll();
            if (v15 == null && this.syncFused) {
                this.runFinally();
            }
            return v15;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    RxJavaPlugins.onError(ex4);
                }
            }
        }
    }
}

