/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBuffer<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int bufferSize;
    final boolean unbounded;
    final boolean delayError;
    final Action onOverflow;
    final Consumer<? super T> onDropped;

    public FlowableOnBackpressureBuffer(Flowable<T> source, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow, Consumer<? super T> onDropped) {
        super(source);
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.delayError = delayError;
        this.onOverflow = onOverflow;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new BackpressureBufferSubscriber<T>(s15, this.bufferSize, this.unbounded, this.delayError, this.onOverflow, this.onDropped));
    }

    static final class BackpressureBufferSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -2514538129242366402L;
        final Subscriber<? super T> downstream;
        final SimplePlainQueue<T> queue;
        final boolean delayError;
        final Action onOverflow;
        final Consumer<? super T> onDropped;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        boolean outputFused;

        BackpressureBufferSubscriber(Subscriber<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.delayError = delayError;
            this.onDropped = onDropped;
            SimplePlainQueue<Object> q15 = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
            this.queue = q15;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            if (!this.queue.offer(t15)) {
                this.upstream.cancel();
                MissingBackpressureException ex4 = new MissingBackpressureException("Buffer is full");
                try {
                    this.onOverflow.run();
                    this.onDropped.accept(t15);
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    ex4.initCause(e15);
                }
                this.onError(ex4);
                return;
            }
            if (this.outputFused) {
                this.downstream.onNext(null);
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            if (this.outputFused) {
                this.downstream.onError(t15);
            } else {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.outputFused) {
                this.downstream.onComplete();
            } else {
                this.drain();
            }
        }

        @Override
        public void request(long n15) {
            if (!this.outputFused && SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (!this.outputFused && this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            block5: {
                if (this.getAndIncrement() != 0) break block5;
                int missed = 1;
                SimplePlainQueue<T> q15 = this.queue;
                Subscriber<T> a15 = this.downstream;
                do {
                    boolean empty;
                    boolean d15;
                    long e15;
                    if (this.checkTerminated(this.done, q15.isEmpty(), a15)) {
                        return;
                    }
                    long r15 = this.requested.get();
                    for (e15 = 0L; e15 != r15; ++e15) {
                        boolean empty2;
                        d15 = this.done;
                        T v15 = q15.poll();
                        boolean bl4 = empty2 = v15 == null;
                        if (this.checkTerminated(d15, empty2, a15)) {
                            return;
                        }
                        if (empty2) break;
                        a15.onNext(v15);
                    }
                    if (e15 == r15 && this.checkTerminated(d15 = this.done, empty = q15.isEmpty(), a15)) {
                        return;
                    }
                    if (e15 == 0L || r15 == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e15);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<? super T> a15) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d15) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e15 = this.error;
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e16 = this.error;
                    if (e16 != null) {
                        this.queue.clear();
                        a15.onError(e16);
                        return true;
                    }
                    if (empty) {
                        a15.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            return this.queue.poll();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

