/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSequenceEqual<T>
extends Flowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int prefetch;

    public FlowableSequenceEqual(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int prefetch) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super Boolean> s15) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(s15, this.prefetch, this.comparer);
        s15.onSubscribe(parent);
        parent.subscribe(this.first, this.second);
    }

    static final class EqualSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4804128302091633067L;
        final EqualCoordinatorHelper parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile SimpleQueue<T> queue;
        volatile boolean done;
        int sourceMode;

        EqualSubscriber(EqualCoordinatorHelper parent, int prefetch) {
            this.parent = parent;
            this.limit = prefetch - (prefetch >> 2);
            this.prefetch = prefetch;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(3);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.sourceMode == 0 && !this.queue.offer(t15)) {
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void request() {
            if (this.sourceMode != 1) {
                long p15 = this.produced + 1L;
                if (p15 >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p15);
                } else {
                    this.produced = p15;
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        void clear() {
            SimpleQueue<T> sq4 = this.queue;
            if (sq4 != null) {
                sq4.clear();
            }
        }
    }

    static final class EqualCoordinator<T>
    extends DeferredScalarSubscription<Boolean>
    implements EqualCoordinatorHelper {
        private static final long serialVersionUID = -6178010334400373240L;
        final BiPredicate<? super T, ? super T> comparer;
        final EqualSubscriber<T> first;
        final EqualSubscriber<T> second;
        final AtomicThrowable errors;
        final AtomicInteger wip;
        T v1;
        T v2;

        EqualCoordinator(Subscriber<? super Boolean> actual, int prefetch, BiPredicate<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
            this.wip = new AtomicInteger();
            this.first = new EqualSubscriber(this, prefetch);
            this.second = new EqualSubscriber(this, prefetch);
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T> source1, Publisher<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.first.cancel();
            this.second.cancel();
            this.errors.tryTerminateAndReport();
            if (this.wip.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex4;
                SimpleQueue q15 = this.first.queue;
                SimpleQueue q25 = this.second.queue;
                if (q15 != null && q25 != null) {
                    while (true) {
                        boolean c15;
                        boolean e25;
                        if (this.isCancelled()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex4 = (Throwable)this.errors.get();
                        if (ex4 != null) {
                            this.cancelAndClear();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean d15 = this.first.done;
                        T a15 = this.v1;
                        if (a15 == null) {
                            try {
                                a15 = q15.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v1 = a15;
                        }
                        boolean e15 = a15 == null;
                        boolean d25 = this.second.done;
                        T b15 = this.v2;
                        if (b15 == null) {
                            try {
                                b15 = q25.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v2 = b15;
                        }
                        boolean bl4 = e25 = b15 == null;
                        if (d15 && d25 && e15 && e25) {
                            this.complete(true);
                            return;
                        }
                        if (d15 && d25 && e15 != e25) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        if (e15 || e25) continue block6;
                        try {
                            c15 = this.comparer.test(a15, b15);
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.errors.tryAddThrowableOrReport(exc);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!c15) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isCancelled()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex4 = (Throwable)this.errors.get();
                if (ex4 == null) continue;
                this.cancelAndClear();
                this.errors.tryTerminateConsumer(this.downstream);
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.drain();
            }
        }
    }

    static interface EqualCoordinatorHelper {
        public void drain();

        public void innerError(Throwable var1);
    }
}

