/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMap;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ObservableWithLatestFromMany<T, R>
extends AbstractObservableWithUpstream<T, R> {
    @Nullable
    final ObservableSource<?>[] otherArray;
    @Nullable
    final Iterable<? extends ObservableSource<?>> otherIterable;
    @NonNull
    final Function<? super Object[], R> combiner;

    public ObservableWithLatestFromMany(@NonNull ObservableSource<T> source, @NonNull ObservableSource<?>[] otherArray, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public ObservableWithLatestFromMany(@NonNull ObservableSource<T> source, @NonNull Iterable<? extends ObservableSource<?>> otherIterable, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        ObservableSource<?>[] others = this.otherArray;
        int n15 = 0;
        if (others == null) {
            others = new ObservableSource[8];
            try {
                for (ObservableSource<?> p15 : this.otherIterable) {
                    if (n15 == others.length) {
                        others = Arrays.copyOf(others, n15 + (n15 >> 1));
                    }
                    others[n15++] = p15;
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error(ex4, observer);
                return;
            }
        } else {
            n15 = others.length;
        }
        if (n15 == 0) {
            new ObservableMap(this.source, new SingletonArrayFunc()).subscribeActual(observer);
            return;
        }
        WithLatestFromObserver parent = new WithLatestFromObserver(observer, this.combiner, n15);
        observer.onSubscribe(parent);
        parent.subscribe(others, n15);
        this.source.subscribe(parent);
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return Objects.requireNonNull(ObservableWithLatestFromMany.this.combiner.apply((Object[])new Object[]{t15}), "The combiner returned a null value");
        }
    }

    static final class WithLatestInnerObserver
    extends AtomicReference<Disposable>
    implements Observer<Object> {
        private static final long serialVersionUID = 3256684027868224024L;
        final WithLatestFromObserver<?, ?> parent;
        final int index;
        boolean hasValue;

        WithLatestInnerObserver(WithLatestFromObserver<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(Object t15) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.parent.innerNext(this.index, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(this.index, t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index, this.hasValue);
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class WithLatestFromObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1577321883966341961L;
        final Observer<? super R> downstream;
        final Function<? super Object[], R> combiner;
        final WithLatestInnerObserver[] observers;
        final AtomicReferenceArray<Object> values;
        final AtomicReference<Disposable> upstream;
        final AtomicThrowable error;
        volatile boolean done;

        WithLatestFromObserver(Observer<? super R> actual, Function<? super Object[], R> combiner, int n15) {
            this.downstream = actual;
            this.combiner = combiner;
            WithLatestInnerObserver[] s15 = new WithLatestInnerObserver[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                s15[i15] = new WithLatestInnerObserver(this, i15);
            }
            this.observers = s15;
            this.values = new AtomicReferenceArray(n15);
            this.upstream = new AtomicReference();
            this.error = new AtomicThrowable();
        }

        void subscribe(ObservableSource<?>[] others, int n15) {
            WithLatestInnerObserver[] observers = this.observers;
            AtomicReference<Disposable> upstream = this.upstream;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (DisposableHelper.isDisposed(upstream.get()) || this.done) {
                    return;
                }
                others[i15].subscribe(observers[i15]);
            }
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this.upstream, d15);
        }

        @Override
        public void onNext(T t15) {
            R v15;
            if (this.done) {
                return;
            }
            AtomicReferenceArray<Object> ara = this.values;
            int n15 = ara.length();
            Object[] objects = new Object[n15 + 1];
            objects[0] = t15;
            for (int i15 = 0; i15 < n15; ++i15) {
                Object o15 = ara.get(i15);
                if (o15 == null) {
                    return;
                }
                objects[i15 + 1] = o15;
            }
            try {
                v15 = Objects.requireNonNull(this.combiner.apply((Object[])objects), "combiner returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.dispose();
                this.onError(ex4);
                return;
            }
            HalfSerializer.onNext(this.downstream, v15, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onError(this.downstream, t15, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.cancelAllBut(-1);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            for (WithLatestInnerObserver observer : this.observers) {
                observer.dispose();
            }
        }

        void innerNext(int index, Object o15) {
            this.values.set(index, o15);
        }

        void innerError(int index, Throwable t15) {
            this.done = true;
            DisposableHelper.dispose(this.upstream);
            this.cancelAllBut(index);
            HalfSerializer.onError(this.downstream, t15, (AtomicInteger)this, this.error);
        }

        void innerComplete(int index, boolean nonEmpty) {
            if (!nonEmpty) {
                this.done = true;
                this.cancelAllBut(index);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        void cancelAllBut(int index) {
            WithLatestInnerObserver[] observers = this.observers;
            for (int i15 = 0; i15 < observers.length; ++i15) {
                if (i15 == index) continue;
                observers[i15].dispose();
            }
        }
    }
}

