/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.single.SingleMap;
import io.reactivex.rxjava3.internal.operators.single.SingleZipArray;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class SingleZipIterable<T, R>
extends Single<R> {
    final Iterable<? extends SingleSource<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    public SingleZipIterable(Iterable<? extends SingleSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        void var5_8;
        SingleSource[] a15 = new SingleSource[8];
        int n15 = 0;
        try {
            for (SingleSource<? extends T> singleSource : this.sources) {
                if (singleSource == null) {
                    EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                    return;
                }
                if (n15 == a15.length) {
                    a15 = Arrays.copyOf(a15, n15 + (n15 >> 2));
                }
                a15[n15++] = singleSource;
            }
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            return;
        }
        if (n15 == 0) {
            EmptyDisposable.error((Throwable)new NoSuchElementException(), observer);
            return;
        }
        if (n15 == 1) {
            a15[0].subscribe(new SingleMap.MapSingleObserver(observer, new SingletonArrayFunc()));
            return;
        }
        SingleZipArray.ZipCoordinator parent = new SingleZipArray.ZipCoordinator(observer, n15, this.zipper);
        observer.onSubscribe(parent);
        boolean bl4 = false;
        while (var5_8 < n15) {
            if (parent.isDisposed()) {
                return;
            }
            a15[var5_8].subscribe(parent.observers[var5_8]);
            ++var5_8;
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return Objects.requireNonNull(SingleZipIterable.this.zipper.apply((Object[])new Object[]{t15}), "The zipper returned a null value");
        }
    }
}

