/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

public final class BackpressureHelper {
    private BackpressureHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static long addCap(long a15, long b15) {
        long u15 = a15 + b15;
        if (u15 < 0L) {
            return Long.MAX_VALUE;
        }
        return u15;
    }

    public static long multiplyCap(long a15, long b15) {
        long u15 = a15 * b15;
        if ((a15 | b15) >>> 31 != 0L && u15 / a15 != b15) {
            return Long.MAX_VALUE;
        }
        return u15;
    }

    public static long add(@NonNull AtomicLong requested, long n15) {
        long u15;
        long r15;
        do {
            if ((r15 = requested.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r15, u15 = BackpressureHelper.addCap(r15, n15)));
        return r15;
    }

    public static long addCancel(@NonNull AtomicLong requested, long n15) {
        long u15;
        long r15;
        do {
            if ((r15 = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (r15 != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r15, u15 = BackpressureHelper.addCap(r15, n15)));
        return r15;
    }

    public static long produced(@NonNull AtomicLong requested, long n15) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n15;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }

    public static long producedCancel(@NonNull AtomicLong requested, long n15) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (current == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n15;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }
}

