/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishSubject<T>
extends Subject<T> {
    static final PublishDisposable[] TERMINATED = new PublishDisposable[0];
    static final PublishDisposable[] EMPTY = new PublishDisposable[0];
    final AtomicReference<PublishDisposable<T>[]> subscribers = new AtomicReference<PublishDisposable[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> PublishSubject<T> create() {
        return new PublishSubject<T>();
    }

    PublishSubject() {
    }

    @Override
    protected void subscribeActual(Observer<? super T> t15) {
        PublishDisposable<T> ps4 = new PublishDisposable<T>(t15, this);
        t15.onSubscribe(ps4);
        if (this.add(ps4)) {
            if (ps4.isDisposed()) {
                this.remove(ps4);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                t15.onError(ex4);
            } else {
                t15.onComplete();
            }
        }
    }

    boolean add(PublishDisposable<T> ps4) {
        PublishDisposable[] b15;
        PublishDisposable<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new PublishDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = ps4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(PublishDisposable<T> ps4) {
        PublishDisposable[] b15;
        PublishDisposable<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED || a15 == EMPTY) {
                return;
            }
            int n15 = a15.length;
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != ps4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new PublishDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.subscribers.get() == TERMINATED) {
            d15.dispose();
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        for (PublishDisposable<T> pd5 : this.subscribers.get()) {
            pd5.onNext(t15);
        }
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.error = t15;
        for (PublishDisposable pd5 : this.subscribers.getAndSet(TERMINATED)) {
            pd5.onError(t15);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishDisposable pd5 : this.subscribers.getAndSet(TERMINATED)) {
            pd5.onComplete();
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    static final class PublishDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 3562861878281475070L;
        final Observer<? super T> downstream;
        final PublishSubject<T> parent;

        PublishDisposable(Observer<? super T> actual, PublishSubject<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void onNext(T t15) {
            if (!this.get()) {
                this.downstream.onNext(t15);
            }
        }

        public void onError(Throwable t15) {
            if (this.get()) {
                RxJavaPlugins.onError(t15);
            } else {
                this.downstream.onError(t15);
            }
        }

        public void onComplete() {
            if (!this.get()) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }
    }
}

