/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.prepare;

import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.usage.UsageInfoVisitor;
import jadx.core.utils.exceptions.JadxException;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="CollectConstValues", desc="Collect and store values from static final fields", runAfter={UsageInfoVisitor.class})
public class CollectConstValues
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        RootNode root = cls.root();
        if (!root.getArgs().isReplaceConsts()) {
            return true;
        }
        if (cls.getFields().isEmpty()) {
            return true;
        }
        ConstStorage constStorage = root.getConstValues();
        for (FieldNode fld : cls.getFields()) {
            try {
                Object value = CollectConstValues.getFieldConstValue(fld);
                if (value == null) continue;
                constStorage.addConstField(fld, value, fld.getAccessFlags().isPublic());
            }
            catch (Exception e15) {
                cls.addWarnComment("Failed to process value of field: " + String.valueOf(fld), e15);
            }
        }
        return true;
    }

    @Nullable
    public static Object getFieldConstValue(FieldNode fld) {
        AccessInfo accFlags = fld.getAccessFlags();
        if (!accFlags.isStatic() || !accFlags.isFinal()) {
            return null;
        }
        EncodedValue constVal = fld.get(JadxAttrType.CONSTANT_VALUE);
        if (constVal == null || constVal == EncodedValue.NULL) {
            return null;
        }
        if (!fld.getUseIn().isEmpty()) {
            return null;
        }
        return constVal.getValue();
    }
}

