/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.android;

import jadx.core.utils.android.ExtDataInput;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class Res9patchStreamDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    public boolean decode(InputStream in4, OutputStream out) {
        try {
            BufferedImage im4 = ImageIO.read(in4);
            NinePatch np4 = this.getNinePatch(in4);
            if (np4 == null) {
                return false;
            }
            int w15 = im4.getWidth();
            int h15 = im4.getHeight();
            BufferedImage im22 = new BufferedImage(w15 + 2, h15 + 2, 2);
            im22.createGraphics().drawImage(im4, 1, 1, w15, h15, null);
            this.drawHLine(im22, h15 + 1, np4.padLeft + 1, w15 - np4.padRight);
            this.drawVLine(im22, w15 + 1, np4.padTop + 1, h15 - np4.padBottom);
            int[] xDivs = np4.xDivs;
            for (int i15 = 0; i15 < xDivs.length - 1; i15 += 2) {
                this.drawHLine(im22, 0, xDivs[i15] + 1, xDivs[i15 + 1]);
            }
            int[] yDivs = np4.yDivs;
            for (int i16 = 0; i16 < yDivs.length - 1; i16 += 2) {
                this.drawVLine(im22, 0, yDivs[i16] + 1, yDivs[i16 + 1]);
            }
            ImageIO.write((RenderedImage)im22, "png", out);
            return true;
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("9patch image decode error", e15);
        }
    }

    @Nullable
    private NinePatch getNinePatch(InputStream in4) throws IOException {
        ExtDataInput di4 = new ExtDataInput(in4);
        if (!this.find9patchChunk(di4)) {
            return null;
        }
        return NinePatch.decode(di4);
    }

    private boolean find9patchChunk(DataInput di4) throws IOException {
        di4.skipBytes(8);
        while (true) {
            int size;
            try {
                size = di4.readInt();
            }
            catch (IOException ex4) {
                return false;
            }
            if (di4.readInt() == 1852855395) {
                return true;
            }
            di4.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im4, int y15, int x15, int x25) {
        for (int x16 = x15; x16 <= x25; ++x16) {
            im4.setRGB(x16, y15, -16777216);
        }
    }

    private void drawVLine(BufferedImage im4, int x15, int y15, int y25) {
        for (int y16 = y15; y16 <= y25; ++y16) {
            im4.setRGB(x15, y16, -16777216);
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
            this.padLeft = padLeft;
            this.padRight = padRight;
            this.padTop = padTop;
            this.padBottom = padBottom;
            this.xDivs = xDivs;
            this.yDivs = yDivs;
        }

        public static NinePatch decode(ExtDataInput di4) throws IOException {
            di4.skipBytes(1);
            byte numXDivs = di4.readByte();
            byte numYDivs = di4.readByte();
            di4.skipBytes(1);
            di4.skipBytes(8);
            int padLeft = di4.readInt();
            int padRight = di4.readInt();
            int padTop = di4.readInt();
            int padBottom = di4.readInt();
            di4.skipBytes(4);
            int[] xDivs = di4.readIntArray(numXDivs);
            int[] yDivs = di4.readIntArray(numYDivs);
            return new NinePatch(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
        }
    }
}

