/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea.theme;

import jadx.gui.ui.codearea.theme.IEditorTheme;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import javax.swing.UIManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.Gutter;

public class DynamicCodeAreaTheme
implements IEditorTheme {
    @Override
    public String getId() {
        return "DynamicCodeAreaTheme";
    }

    @Override
    public String getName() {
        return NLS.str("preferences.dynamic_editor_theme");
    }

    @Override
    public void apply(RSyntaxTextArea textArea) {
        Color dataTypeColor;
        Color themeBackground = UIManager.getColor("Panel.background");
        Color themeForeground = UIManager.getColor("Panel.foreground");
        Color separatorForeground = UIManager.getColor("Separator.foreground");
        Color editorSelectionBackground = UIManager.getColor("EditorPane.selectionBackground");
        Color caretForeground = UIManager.getColor("EditorPane.caretForeground");
        SyntaxScheme scheme = textArea.getSyntaxScheme();
        boolean isDarkTheme = UiUtils.isDarkTheme(themeBackground);
        Color editorBackground = isDarkTheme ? themeBackground : Color.WHITE;
        Color lineHighlight = isDarkTheme ? UiUtils.adjustBrightness(themeBackground, 1.2f) : Color.decode("#EBECF0");
        Color lineNumberForeground = UIManager.getColor("Label.foreground");
        Color selectionColor = isDarkTheme ? new Color(51, 153, 255, 90) : new Color(51, 153, 255, 50);
        Color markAllHighlightColor = isDarkTheme ? Color.decode("#32593D") : Color.decode("#ffc800");
        Color matchedBracketBackground = isDarkTheme ? UiUtils.adjustBrightness(Color.decode("#3B514D"), 1.2f) : Color.decode("#93D9D9");
        Color markOccurrencesColor = UiUtils.adjustBrightness(editorSelectionBackground, isDarkTheme ? 0.6f : 1.4f);
        if (isDarkTheme) {
            dataTypeColor = Color.decode("#4EC9B0");
            scheme.getStyle((int)1).foreground = Color.decode("#57A64A");
            scheme.getStyle((int)2).foreground = Color.decode("#57A64A");
            scheme.getStyle((int)3).foreground = Color.decode("#57A64A");
            scheme.getStyle((int)4).foreground = Color.decode("#57A64A");
            scheme.getStyle((int)5).foreground = Color.decode("#57A64A");
            scheme.getStyle((int)6).foreground = Color.decode("#569CD6");
            scheme.getStyle((int)7).foreground = dataTypeColor;
            scheme.getStyle((int)8).foreground = Color.decode("#DCDCAA");
            scheme.getStyle((int)19).foreground = Color.decode("#B3AE60");
            scheme.getStyle((int)10).foreground = Color.decode("#D7BA7D");
            scheme.getStyle((int)11).foreground = Color.decode("#D7BA7D");
            scheme.getStyle((int)12).foreground = Color.decode("#D7BA7D");
            scheme.getStyle((int)9).foreground = Color.decode("#569CD6");
            scheme.getStyle((int)14).foreground = Color.decode("#CE9178");
            scheme.getStyle((int)13).foreground = Color.decode("#CE9178");
            scheme.getStyle((int)16).foreground = dataTypeColor;
            scheme.getStyle((int)23).foreground = Color.WHITE;
            scheme.getStyle((int)22).foreground = Color.WHITE;
            scheme.getStyle((int)20).foreground = themeForeground;
            scheme.getStyle((int)25).foreground = Color.decode("#808080");
            scheme.getStyle((int)26).foreground = Color.decode("#569CD6");
            scheme.getStyle((int)27).foreground = Color.decode("#9CDCFE");
            scheme.getStyle((int)28).foreground = Color.decode("#CE9178");
        } else {
            dataTypeColor = Color.decode("#267F99");
            scheme.getStyle((int)1).foreground = Color.decode("#008000");
            scheme.getStyle((int)2).foreground = Color.decode("#008000");
            scheme.getStyle((int)3).foreground = Color.decode("#008000");
            scheme.getStyle((int)4).foreground = Color.decode("#008000");
            scheme.getStyle((int)5).foreground = Color.decode("#008000");
            scheme.getStyle((int)6).foreground = Color.decode("#0000FF");
            scheme.getStyle((int)7).foreground = dataTypeColor;
            scheme.getStyle((int)8).foreground = Color.decode("#795E26");
            scheme.getStyle((int)19).foreground = Color.decode("#9E8809");
            scheme.getStyle((int)10).foreground = Color.decode("#098658");
            scheme.getStyle((int)11).foreground = Color.decode("#098658");
            scheme.getStyle((int)12).foreground = Color.decode("#098658");
            scheme.getStyle((int)9).foreground = Color.decode("#0451A5");
            scheme.getStyle((int)14).foreground = Color.decode("#067d17");
            scheme.getStyle((int)13).foreground = Color.decode("#067d17");
            scheme.getStyle((int)16).foreground = dataTypeColor;
            scheme.getStyle((int)23).foreground = Color.decode("#333333");
            scheme.getStyle((int)22).foreground = Color.decode("#333333");
            scheme.getStyle((int)20).foreground = themeForeground;
            scheme.getStyle((int)25).foreground = Color.decode("#800000");
            scheme.getStyle((int)26).foreground = Color.decode("#4A7A4F");
            scheme.getStyle((int)27).foreground = Color.decode("#FF0000");
            scheme.getStyle((int)28).foreground = Color.decode("#0000FF");
        }
        textArea.setBackground(editorBackground);
        textArea.setCaretColor(caretForeground);
        textArea.setSelectionColor(selectionColor);
        textArea.setCurrentLineHighlightColor(lineHighlight);
        textArea.setMarkAllHighlightColor(markAllHighlightColor);
        textArea.setMarkOccurrencesColor(markOccurrencesColor);
        textArea.setHyperlinkForeground(editorSelectionBackground);
        textArea.setMatchedBracketBGColor(matchedBracketBackground);
        textArea.setMatchedBracketBorderColor(lineNumberForeground);
        textArea.setPaintMatchedBracketPair(true);
        textArea.setAnimateBracketMatching(false);
        textArea.setFadeCurrentLineHighlight(true);
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            gutter.setBackground(editorBackground);
            gutter.setBorderColor(separatorForeground);
            gutter.setLineNumberColor(lineNumberForeground);
        }
    }
}

