/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.popupmenu;

import jadx.api.DecompilationMode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.mode.JCodeMode;
import jadx.gui.ui.dialog.RenameDialog;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.ui.popupmenu.JClassExportType;
import jadx.gui.utils.NLS;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JClassPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -7781009781149260806L;
    private static final Logger LOG = LoggerFactory.getLogger(JClassPopupMenu.class);
    private final transient MainWindow mainWindow;

    public JClassPopupMenu(MainWindow mainWindow, JClass jClass) {
        this.mainWindow = mainWindow;
        this.add(RenameDialog.buildRenamePopupMenuItem(mainWindow, jClass));
        this.add(this.makeExportSubMenu(jClass));
    }

    private JMenuItem makeExportSubMenu(JClass jClass) {
        JMenu exportSubMenu = new JMenu(NLS.str("popup.export"));
        exportSubMenu.add(this.makeExportMenuItem(jClass, NLS.str("tabs.code"), JClassExportType.Code));
        exportSubMenu.add(this.makeExportMenuItem(jClass, NLS.str("tabs.smali"), JClassExportType.Smali));
        exportSubMenu.add(this.makeExportMenuItem(jClass, "Simple", JClassExportType.Simple));
        exportSubMenu.add(this.makeExportMenuItem(jClass, "Fallback", JClassExportType.Fallback));
        return exportSubMenu;
    }

    public JMenuItem makeExportMenuItem(JClass jClass, String label, JClassExportType exportType) {
        JMenuItem exportMenuItem = new JMenuItem(label);
        exportMenuItem.addActionListener(event -> {
            List<Path> selectedPaths;
            String fileName = jClass.getName() + "." + exportType.extension;
            FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.EXPORT_NODE);
            fileDialog.setFileExtList(Collections.singletonList(exportType.extension));
            Path currentDir = fileDialog.getCurrentDir();
            if (currentDir != null) {
                fileDialog.setSelectedFile(currentDir.resolve(fileName));
            }
            if ((selectedPaths = fileDialog.show()).size() != 1) {
                return;
            }
            Path selectedPath = selectedPaths.get(0);
            Path savePath = !selectedPath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(exportType.extension) ? selectedPath.resolveSibling(String.valueOf(selectedPath.getFileName()) + "." + exportType.extension) : selectedPath;
            JClassPopupMenu.saveJClass(jClass, savePath, exportType);
            LOG.info("Done saving {}", (Object)savePath);
        });
        return exportMenuItem;
    }

    public static void saveJClass(JClass jClass, Path savePath, JClassExportType exportType) {
        try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(JClassPopupMenu.getCode(jClass, exportType));
        }
        catch (Exception e15) {
            throw new RuntimeException("Error saving project", e15);
        }
    }

    private static String getCode(JClass jClass, JClassExportType exportType) {
        switch (exportType) {
            case Code: {
                return jClass.getCodeInfo().getCodeStr();
            }
            case Smali: {
                return jClass.getSmali();
            }
            case Simple: {
                JCodeMode jClassSimple = new JCodeMode(jClass, DecompilationMode.SIMPLE);
                return ((JNode)jClassSimple).getCodeInfo().getCodeStr();
            }
            case Fallback: {
                JCodeMode jClassFallback = new JCodeMode(jClass, DecompilationMode.FALLBACK);
                return ((JNode)jClassFallback).getCodeInfo().getCodeStr();
            }
        }
        throw new RuntimeException("Unsupported JClassExportType " + String.valueOf((Object)exportType));
    }
}

