/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.insns;

import jadx.api.plugins.input.insns.custom.impl.SwitchPayload;
import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.insns.DexInsnData;
import jadx.plugins.input.dex.insns.payloads.DexArrayPayload;
import jadx.plugins.input.dex.sections.SectionReader;

public abstract class DexInsnFormat {
    public static final DexInsnFormat FORMAT_10X = new DexInsnFormat(1, 0){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
        }
    };
    public static final DexInsnFormat FORMAT_12X = new DexInsnFormat(1, 2){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.nibble2(opcodeUnit);
            regs[1] = DexInsnFormat.nibble3(opcodeUnit);
        }
    };
    public static final DexInsnFormat FORMAT_11N = new DexInsnFormat(1, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.nibble2(opcodeUnit);
            insn.setLiteral(DexInsnFormat.signedNibble3(opcodeUnit));
        }
    };
    public static final DexInsnFormat FORMAT_11X = new DexInsnFormat(1, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
        }
    };
    public static final DexInsnFormat FORMAT_10T = new DexInsnFormat(1, 0){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            insn.setTarget(insn.getOffset() + DexInsnFormat.signedByte1(opcodeUnit));
        }
    };
    public static final DexInsnFormat FORMAT_20T = new DexInsnFormat(2, 0){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            insn.setTarget(insn.getOffset() + in4.readShort());
        }
    };
    public static final DexInsnFormat FORMAT_20BC = new DexInsnFormat(2, 0){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            insn.setLiteral(DexInsnFormat.byte1(opcodeUnit));
            insn.setIndex(in4.readUShort());
        }
    };
    public static final DexInsnFormat FORMAT_22X = new DexInsnFormat(2, 2){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            regs[1] = in4.readUShort();
        }
    };
    public static final DexInsnFormat FORMAT_21T = new DexInsnFormat(2, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            insn.setTarget(insn.getOffset() + in4.readShort());
        }
    };
    public static final DexInsnFormat FORMAT_21S = new DexInsnFormat(2, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            insn.setLiteral(in4.readShort());
        }
    };
    public static final DexInsnFormat FORMAT_21H = new DexInsnFormat(2, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            long literal = in4.readShort();
            insn.setLiteral(literal <<= DexInsnFormat.byte0(opcodeUnit) == 21 ? 16 : 48);
        }
    };
    public static final DexInsnFormat FORMAT_21C = new DexInsnFormat(2, 1){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            insn.setIndex(in4.readUShort());
        }
    };
    public static final DexInsnFormat FORMAT_23X = new DexInsnFormat(2, 3){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            int next = in4.readUShort();
            regs[1] = DexInsnFormat.byte0(next);
            regs[2] = DexInsnFormat.byte1(next);
        }
    };
    public static final DexInsnFormat FORMAT_22B = new DexInsnFormat(2, 2){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.byte1(opcodeUnit);
            int next = in4.readUShort();
            regs[1] = DexInsnFormat.byte0(next);
            insn.setLiteral(DexInsnFormat.signedByte1(next));
        }
    };
    public static final DexInsnFormat FORMAT_22T = new DexInsnFormat(2, 2){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.nibble2(opcodeUnit);
            regs[1] = DexInsnFormat.nibble3(opcodeUnit);
            insn.setTarget(insn.getOffset() + in4.readShort());
        }
    };
    public static final DexInsnFormat FORMAT_22S = new DexInsnFormat(2, 2){

        @Override
        public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
            int[] regs = insn.getArgsReg();
            regs[0] = DexInsnFormat.nibble2(opcodeUnit);
            regs[1] = DexInsnFormat.nibble3(opcodeUnit);
            insn.setLiteral(in4.readShort());
        }
    };
    public static final DexInsnFormat FORMAT_22C;
    public static final DexInsnFormat FORMAT_22CS;
    public static final DexInsnFormat FORMAT_30T;
    public static final DexInsnFormat FORMAT_32X;
    public static final DexInsnFormat FORMAT_31I;
    public static final DexInsnFormat FORMAT_31T;
    public static final DexInsnFormat FORMAT_31C;
    public static final DexInsnFormat FORMAT_35C;
    public static final DexInsnFormat FORMAT_35MS;
    public static final DexInsnFormat FORMAT_35MI;
    public static final DexInsnFormat FORMAT_3RC;
    public static final DexInsnFormat FORMAT_3RMS;
    public static final DexInsnFormat FORMAT_3RMI;
    public static final DexInsnFormat FORMAT_45CC;
    public static final DexInsnFormat FORMAT_4RCC;
    public static final DexInsnFormat FORMAT_51I;
    public static final DexInsnFormat FORMAT_PACKED_SWITCH_PAYLOAD;
    public static final DexInsnFormat FORMAT_SPARSE_SWITCH_PAYLOAD;
    public static final DexInsnFormat FORMAT_FILL_ARRAY_DATA_PAYLOAD;
    private final int length;
    private final int regsCount;

    protected void readRegsList(DexInsnData insn, int opcodeUnit, SectionReader in4) {
        int regsCount1 = DexInsnFormat.nibble3(opcodeUnit);
        int index = in4.readUShort();
        int rs4 = in4.readUShort();
        int[] regs = insn.getArgsReg();
        regs[0] = DexInsnFormat.nibble0(rs4);
        regs[1] = DexInsnFormat.nibble1(rs4);
        regs[2] = DexInsnFormat.nibble2(rs4);
        regs[3] = DexInsnFormat.nibble3(rs4);
        regs[4] = DexInsnFormat.nibble2(opcodeUnit);
        insn.setRegsCount(regsCount1);
        insn.setIndex(index);
    }

    protected void readRegsRange(DexInsnData insn, int opcodeUnit, SectionReader in4) {
        int regsCount = DexInsnFormat.byte1(opcodeUnit);
        int index = in4.readUShort();
        int startReg = in4.readUShort();
        int[] regs = insn.getArgsReg();
        if (regs.length < regsCount) {
            regs = new int[regsCount];
            insn.setArgsReg(regs);
        }
        int regNum = startReg;
        for (int i15 = 0; i15 < regsCount; ++i15) {
            regs[i15] = regNum++;
        }
        insn.setRegsCount(regsCount);
        insn.setIndex(index);
    }

    protected DexInsnFormat(int length, int regsCount) {
        this.length = length;
        this.regsCount = regsCount;
    }

    public abstract void decode(DexInsnData var1, int var2, SectionReader var3);

    public void skip(DexInsnData insn, SectionReader in4) {
        int len = this.length;
        if (len == 1) {
            return;
        }
        in4.skip((len - 1) * 2);
    }

    public int getLength() {
        return this.length;
    }

    public int getRegsCount() {
        return this.regsCount;
    }

    private static int byte0(int value) {
        return value & 0xFF;
    }

    private static int byte1(int value) {
        return value >> 8 & 0xFF;
    }

    private static int signedByte1(int value) {
        return (byte)(value >> 8);
    }

    private static int nibble0(int value) {
        return value & 0xF;
    }

    private static int nibble1(int value) {
        return value >> 4 & 0xF;
    }

    private static int nibble2(int value) {
        return value >> 8 & 0xF;
    }

    private static int nibble3(int value) {
        return value >> 12 & 0xF;
    }

    private static int signedNibble3(int value) {
        return (value >> 12 & 0xF) << 28 >> 28;
    }

    static {
        FORMAT_22CS = FORMAT_22C = new DexInsnFormat(2, 2){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = DexInsnFormat.nibble2(opcodeUnit);
                regs[1] = DexInsnFormat.nibble3(opcodeUnit);
                insn.setIndex(in4.readUShort());
                insn.setLiteral(0L);
            }
        };
        FORMAT_30T = new DexInsnFormat(3, 0){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                insn.setTarget(insn.getOffset() + in4.readInt());
            }
        };
        FORMAT_32X = new DexInsnFormat(3, 2){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = in4.readUShort();
                regs[1] = in4.readUShort();
            }
        };
        FORMAT_31I = new DexInsnFormat(3, 1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = DexInsnFormat.byte1(opcodeUnit);
                insn.setLiteral(in4.readInt());
            }
        };
        FORMAT_31T = new DexInsnFormat(3, 1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = DexInsnFormat.byte1(opcodeUnit);
                insn.setTarget(insn.getOffset() + in4.readInt());
            }
        };
        FORMAT_31C = new DexInsnFormat(3, 1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = DexInsnFormat.byte1(opcodeUnit);
                insn.setIndex(in4.readInt());
            }
        };
        FORMAT_35MS = FORMAT_35C = new DexInsnFormat(3, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                this.readRegsList(insn, opcodeUnit, in4);
            }
        };
        FORMAT_35MI = FORMAT_35C;
        FORMAT_3RMS = FORMAT_3RC = new DexInsnFormat(3, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                this.readRegsRange(insn, opcodeUnit, in4);
            }
        };
        FORMAT_3RMI = FORMAT_3RC;
        FORMAT_45CC = new DexInsnFormat(4, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                this.readRegsList(insn, opcodeUnit, in4);
                insn.setTarget(in4.readUShort());
            }
        };
        FORMAT_4RCC = new DexInsnFormat(4, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                this.readRegsRange(insn, opcodeUnit, in4);
                insn.setTarget(in4.readUShort());
            }
        };
        FORMAT_51I = new DexInsnFormat(5, 1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int[] regs = insn.getArgsReg();
                regs[0] = DexInsnFormat.byte1(opcodeUnit);
                insn.setLiteral(in4.readLong());
            }
        };
        FORMAT_PACKED_SWITCH_PAYLOAD = new DexInsnFormat(-1, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int size = in4.readUShort();
                int firstKey = in4.readInt();
                int[] keys2 = new int[size];
                int[] targets = new int[size];
                for (int i15 = 0; i15 < size; ++i15) {
                    targets[i15] = in4.readInt();
                    keys2[i15] = firstKey + i15;
                }
                insn.setPayload(new SwitchPayload(size, keys2, targets));
                insn.setLength(size * 2 + 4);
            }

            @Override
            public void skip(DexInsnData insn, SectionReader in4) {
                int size = in4.readUShort();
                in4.skip(4 + size * 4);
                insn.setLength(size * 2 + 4);
            }
        };
        FORMAT_SPARSE_SWITCH_PAYLOAD = new DexInsnFormat(-1, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                int size = in4.readUShort();
                int[] keys2 = new int[size];
                for (int i15 = 0; i15 < size; ++i15) {
                    keys2[i15] = in4.readInt();
                }
                int[] targets = new int[size];
                for (int i16 = 0; i16 < size; ++i16) {
                    targets[i16] = in4.readInt();
                }
                insn.setPayload(new SwitchPayload(size, keys2, targets));
                insn.setLength(size * 4 + 2);
            }

            @Override
            public void skip(DexInsnData insn, SectionReader in4) {
                int size = in4.readUShort();
                in4.skip(size * 8);
                insn.setLength(size * 4 + 2);
            }
        };
        FORMAT_FILL_ARRAY_DATA_PAYLOAD = new DexInsnFormat(-1, -1){

            @Override
            public void decode(DexInsnData insn, int opcodeUnit, SectionReader in4) {
                Object[] data;
                int elemSize = in4.readUShort();
                int size = in4.readInt();
                switch (elemSize) {
                    case 1: {
                        data = in4.readByteArray(size);
                        if (size % 2 == 0) break;
                        in4.readUByte();
                        break;
                    }
                    case 2: {
                        short[] array = new short[size];
                        for (int i15 = 0; i15 < size; ++i15) {
                            array[i15] = (short)in4.readShort();
                        }
                        data = array;
                        break;
                    }
                    case 4: {
                        int[] array = new int[size];
                        for (int i16 = 0; i16 < size; ++i16) {
                            array[i16] = in4.readInt();
                        }
                        data = array;
                        break;
                    }
                    case 8: {
                        long[] array = new long[size];
                        for (int i17 = 0; i17 < size; ++i17) {
                            array[i17] = in4.readLong();
                        }
                        data = array;
                        break;
                    }
                    case 0: {
                        data = new byte[]{};
                        break;
                    }
                    default: {
                        throw new DexException("Unexpected element size in FILL_ARRAY_DATA_PAYLOAD: " + elemSize);
                    }
                }
                insn.setLength((size * elemSize + 1) / 2 + 4);
                insn.setPayload(new DexArrayPayload(size, elemSize, data));
            }

            @Override
            public void skip(DexInsnData insn, SectionReader in4) {
                int elemSize = in4.readUShort();
                int size = in4.readInt();
                if (elemSize == 1) {
                    in4.skip(size + size % 2);
                } else {
                    in4.skip(size * elemSize);
                }
                insn.setLength((size * elemSize + 1) / 2 + 4);
            }
        };
    }
}

