/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.nio.CharBuffer;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;

class AlphanumericComparator
implements Comparator<CharSequence> {
    private final Collator collator;

    AlphanumericComparator() {
        this.collator = null;
    }

    AlphanumericComparator(Locale locale) {
        this(Collator.getInstance(Objects.requireNonNull(locale)));
    }

    AlphanumericComparator(Collator collator) {
        this.collator = Objects.requireNonNull(collator);
    }

    @Override
    public int compare(CharSequence s15, CharSequence s25) {
        CharBuffer b15 = CharBuffer.wrap(s15);
        CharBuffer b25 = CharBuffer.wrap(s25);
        while (b15.hasRemaining() && b25.hasRemaining()) {
            this.moveWindow(b15);
            this.moveWindow(b25);
            int result = this.compare(b15, b25);
            if (result != 0) {
                return result;
            }
            this.prepareForNextIteration(b15);
            this.prepareForNextIteration(b25);
        }
        return s15.length() - s25.length();
    }

    private void moveWindow(CharBuffer buffer) {
        int start = buffer.position();
        int end = buffer.position();
        boolean isNumerical = this.isDigit(buffer.get(start));
        while (end < buffer.limit() && isNumerical == this.isDigit(buffer.get(end))) {
            if (!isNumerical || start + 1 >= buffer.limit() || !this.isZero(buffer.get(start)) || !this.isDigit(buffer.get(++end))) continue;
            ++start;
        }
        buffer.position(start).limit(end);
    }

    @Override
    private int compare(CharBuffer b15, CharBuffer b25) {
        if (this.isNumerical(b15) && this.isNumerical(b25)) {
            return this.compareNumerically(b15, b25);
        }
        return this.compareAsStrings(b15, b25);
    }

    private boolean isNumerical(CharBuffer buffer) {
        return this.isDigit(buffer.charAt(0));
    }

    private boolean isDigit(char c15) {
        if (this.collator == null) {
            char intValue = c15;
            return intValue >= '0' && intValue <= '9';
        }
        return Character.isDigit(c15);
    }

    private int compareNumerically(CharBuffer b15, CharBuffer b25) {
        int diff = b15.length() - b25.length();
        if (diff != 0) {
            return diff;
        }
        for (int i15 = 0; i15 < b15.remaining() && i15 < b25.remaining(); ++i15) {
            int result = Character.compare(b15.charAt(i15), b25.charAt(i15));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private void prepareForNextIteration(CharBuffer buffer) {
        buffer.position(buffer.limit()).limit(buffer.capacity());
    }

    private int compareAsStrings(CharBuffer b15, CharBuffer b25) {
        if (this.collator != null) {
            return this.collator.compare(b15.toString(), b25.toString());
        }
        return b15.toString().compareTo(b25.toString());
    }

    private boolean isZero(char c15) {
        return c15 == '0';
    }
}

