/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.language;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ActionEvaluator;
import org.antlr.stringtemplate.language.ArrayWrappedInList;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.StringTemplateAST;

public class ASTExpr
extends Expr {
    public static final int MISSING = -1;
    public static final String DEFAULT_ATTRIBUTE_NAME = "it";
    public static final String DEFAULT_ATTRIBUTE_NAME_DEPRECATED = "attr";
    public static final String DEFAULT_INDEX_VARIABLE_NAME = "i";
    public static final String DEFAULT_INDEX0_VARIABLE_NAME = "i0";
    public static final String DEFAULT_MAP_VALUE_NAME = "_default_";
    public static final String DEFAULT_MAP_KEY_NAME = "key";
    public static final StringTemplate MAP_KEY_VALUE = new StringTemplate();
    public static final String EMPTY_OPTION = "empty expr option";
    public static final Map defaultOptionValues = new HashMap(){
        {
            this.put("anchor", new StringTemplateAST(34, "true"));
            this.put("wrap", new StringTemplateAST(34, "\n"));
        }
    };
    public static final Set supportedOptions = new HashSet(){
        {
            this.add("anchor");
            this.add("format");
            this.add("null");
            this.add("separator");
            this.add("wrap");
        }
    };
    AST exprTree = null;
    Map options = null;
    String wrapString = null;
    String nullValue = null;
    String separatorString = null;
    String formatString = null;

    public ASTExpr(StringTemplate enclosingTemplate, AST exprTree, Map options) {
        super(enclosingTemplate);
        this.exprTree = exprTree;
        this.options = options;
    }

    public AST getAST() {
        return this.exprTree;
    }

    public int write(StringTemplate self, StringTemplateWriter out) throws IOException {
        if (this.exprTree == null || self == null || out == null) {
            return 0;
        }
        StringTemplateAST anchorAST = (StringTemplateAST)this.getOption("anchor");
        if (anchorAST != null) {
            out.pushAnchorPoint();
        }
        out.pushIndentation(this.getIndentation());
        this.handleExprOptions(self);
        ActionEvaluator eval = new ActionEvaluator(self, this, out);
        int n15 = 0;
        try {
            n15 = eval.action(this.exprTree);
        }
        catch (RecognitionException re5) {
            self.error("can't evaluate tree: " + this.exprTree.toStringList(), re5);
        }
        out.popIndentation();
        if (anchorAST != null) {
            out.popAnchorPoint();
        }
        return n15;
    }

    protected void handleExprOptions(StringTemplate self) {
        StringTemplateAST formatAST;
        StringTemplateAST separatorAST;
        StringTemplateAST nullValueAST;
        this.formatString = null;
        StringTemplateAST wrapAST = (StringTemplateAST)this.getOption("wrap");
        if (wrapAST != null) {
            this.wrapString = this.evaluateExpression(self, wrapAST);
        }
        if ((nullValueAST = (StringTemplateAST)this.getOption("null")) != null) {
            this.nullValue = this.evaluateExpression(self, nullValueAST);
        }
        if ((separatorAST = (StringTemplateAST)this.getOption("separator")) != null) {
            this.separatorString = this.evaluateExpression(self, separatorAST);
        }
        if ((formatAST = (StringTemplateAST)this.getOption("format")) != null) {
            this.formatString = this.evaluateExpression(self, formatAST);
        }
        if (this.options != null) {
            Iterator it = this.options.keySet().iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                if (supportedOptions.contains(option)) continue;
                self.warning("ignoring unsupported option: " + option);
            }
        }
    }

    public Object applyTemplateToListOfAttributes(StringTemplate self, List attributes, StringTemplate templateToApply) {
        if (attributes == null || templateToApply == null || attributes.size() == 0) {
            return null;
        }
        HashMap<String, Object> argumentContext = null;
        StringTemplate.STAttributeList results = new StringTemplate.STAttributeList();
        for (int a15 = 0; a15 < attributes.size(); ++a15) {
            Object o15 = attributes.get(a15);
            if (o15 == null) continue;
            o15 = ASTExpr.convertAnythingToIterator(o15);
            attributes.set(a15, o15);
        }
        int numAttributes = attributes.size();
        Map formalArguments = templateToApply.getFormalArguments();
        if (formalArguments == null || formalArguments.size() == 0) {
            self.error("missing arguments in anonymous template in context " + self.getEnclosingInstanceStackString());
            return null;
        }
        Object[] formalArgumentNames = formalArguments.keySet().toArray();
        if (formalArgumentNames.length != numAttributes) {
            int shorterSize;
            self.error("number of arguments " + formalArguments.keySet() + " mismatch between attribute list and anonymous" + " template in context " + self.getEnclosingInstanceStackString());
            numAttributes = shorterSize = Math.min(formalArgumentNames.length, numAttributes);
            Object[] newFormalArgumentNames = new Object[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        int i15 = 0;
        while (true) {
            argumentContext = new HashMap<String, Object>();
            int numEmpty = 0;
            for (int a16 = 0; a16 < numAttributes; ++a16) {
                Iterator it = (Iterator)attributes.get(a16);
                if (it != null && it.hasNext()) {
                    String argName = (String)formalArgumentNames[a16];
                    Object iteratedValue = it.next();
                    argumentContext.put(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numAttributes) break;
            argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(i15 + 1));
            argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(i15));
            StringTemplate embedded = templateToApply.getInstanceOf();
            embedded.setEnclosingInstance(self);
            embedded.setArgumentContext(argumentContext);
            results.add(embedded);
            ++i15;
        }
        return results;
    }

    public Object applyListOfAlternatingTemplates(StringTemplate self, Object attributeValue, List templatesToApply) {
        boolean isAnonymous;
        if (attributeValue == null || templatesToApply == null || templatesToApply.size() == 0) {
            return null;
        }
        StringTemplate embedded = null;
        HashMap<String, Object> argumentContext = null;
        attributeValue = ASTExpr.convertArrayToList(attributeValue);
        if ((attributeValue = ASTExpr.convertAnythingIteratableToIterator(attributeValue)) instanceof Iterator) {
            StringTemplate.STAttributeList resultVector = new StringTemplate.STAttributeList();
            Iterator iter = (Iterator)attributeValue;
            int i15 = 0;
            while (iter.hasNext()) {
                Object ithValue = iter.next();
                if (ithValue == null) {
                    if (this.nullValue == null) continue;
                    ithValue = this.nullValue;
                }
                int templateIndex = i15 % templatesToApply.size();
                embedded = (StringTemplate)templatesToApply.get(templateIndex);
                StringTemplateAST args = embedded.getArgumentsAST();
                embedded = embedded.getInstanceOf();
                embedded.setEnclosingInstance(self);
                embedded.setArgumentsAST(args);
                argumentContext = new HashMap();
                Map formalArgs = embedded.getFormalArguments();
                boolean isAnonymous2 = embedded.getName() == "anonymous";
                this.setSoleFormalArgumentToIthValue(embedded, argumentContext, ithValue);
                if (!isAnonymous2 || formalArgs == null || formalArgs.size() <= 0) {
                    argumentContext.put(DEFAULT_ATTRIBUTE_NAME, ithValue);
                    argumentContext.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, ithValue);
                }
                argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(i15 + 1));
                argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(i15));
                embedded.setArgumentContext(argumentContext);
                this.evaluateArguments(embedded);
                resultVector.add(embedded);
                ++i15;
            }
            if (resultVector.size() == 0) {
                resultVector = null;
            }
            return resultVector;
        }
        embedded = (StringTemplate)templatesToApply.get(0);
        argumentContext = new HashMap<String, Object>();
        Map formalArgs = embedded.getFormalArguments();
        StringTemplateAST args = embedded.getArgumentsAST();
        this.setSoleFormalArgumentToIthValue(embedded, argumentContext, attributeValue);
        boolean bl4 = isAnonymous = embedded.getName() == "anonymous";
        if (!isAnonymous || formalArgs == null || formalArgs.size() <= 0) {
            argumentContext.put(DEFAULT_ATTRIBUTE_NAME, attributeValue);
            argumentContext.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, attributeValue);
        }
        argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(1));
        argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(0));
        embedded.setArgumentContext(argumentContext);
        this.evaluateArguments(embedded);
        return embedded;
    }

    protected void setSoleFormalArgumentToIthValue(StringTemplate embedded, Map argumentContext, Object ithValue) {
        Map formalArgs = embedded.getFormalArguments();
        if (formalArgs != null) {
            boolean isAnonymous;
            String soleArgName = null;
            boolean bl4 = isAnonymous = embedded.getName() == "anonymous";
            if (formalArgs.size() == 1 || isAnonymous && formalArgs.size() > 0) {
                if (isAnonymous && formalArgs.size() > 1) {
                    embedded.error("too many arguments on {...} template: " + formalArgs);
                }
                Set argNames = formalArgs.keySet();
                soleArgName = (String)argNames.toArray()[0];
                argumentContext.put(soleArgName, ithValue);
            }
        }
    }

    public Object getObjectProperty(StringTemplate self, Object o15, Object propertyName) {
        if (o15 == null || propertyName == null) {
            return null;
        }
        Object value = this.rawGetObjectProperty(self, o15, propertyName);
        value = ASTExpr.convertArrayToList(value);
        return value;
    }

    protected Object rawGetObjectProperty(StringTemplate self, Object o15, Object property) {
        Map attributes;
        Class<?> c15 = o15.getClass();
        Object value = null;
        if (c15 == StringTemplate.Aggregate.class) {
            String propertyName = (String)property;
            value = ((StringTemplate.Aggregate)o15).get(propertyName);
            return value;
        }
        if (c15 == StringTemplate.class && (attributes = ((StringTemplate)o15).getAttributes()) != null) {
            String propertyName = (String)property;
            value = attributes.get(propertyName);
            return value;
        }
        if (o15 instanceof Map) {
            Map map = (Map)o15;
            if (property.equals("keys")) {
                value = map.keySet();
            } else if (property.equals("values")) {
                value = map.values();
            } else if (map.containsKey(property)) {
                value = map.get(property);
            } else if (map.containsKey(property.toString())) {
                value = map.get(property.toString());
            } else if (map.containsKey(DEFAULT_MAP_VALUE_NAME)) {
                value = map.get(DEFAULT_MAP_VALUE_NAME);
            }
            if (value == MAP_KEY_VALUE) {
                value = property;
            }
            return value;
        }
        Method m15 = null;
        String propertyName = (String)property;
        String methodSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length());
        m15 = this.getMethod(c15, "get" + methodSuffix);
        if (m15 == null) {
            m15 = this.getMethod(c15, "is" + methodSuffix);
        }
        if (m15 != null) {
            try {
                value = this.invokeMethod(m15, o15, value);
            }
            catch (Exception e15) {
                self.error("Can't get property " + propertyName + " using method get/is" + methodSuffix + " from " + c15.getName() + " instance", e15);
            }
        } else {
            try {
                Field f15 = c15.getField(propertyName);
                try {
                    value = this.accessField(f15, o15, value);
                }
                catch (IllegalAccessException iae) {
                    self.error("Can't access property " + propertyName + " using method get/is" + methodSuffix + " or direct field access from " + c15.getName() + " instance", iae);
                }
            }
            catch (NoSuchFieldException nsfe) {
                self.error("Class " + c15.getName() + " has no such attribute: " + propertyName + " in template context " + self.getEnclosingInstanceStackString(), nsfe);
            }
        }
        return value;
    }

    protected Object accessField(Field f15, Object o15, Object value) throws IllegalAccessException {
        try {
            f15.setAccessible(true);
        }
        catch (SecurityException se5) {
            // empty catch block
        }
        value = f15.get(o15);
        return value;
    }

    protected Object invokeMethod(Method m15, Object o15, Object value) throws IllegalAccessException, InvocationTargetException {
        try {
            m15.setAccessible(true);
        }
        catch (SecurityException se5) {
            // empty catch block
        }
        value = m15.invoke(o15, (Object[])null);
        return value;
    }

    protected Method getMethod(Class c15, String methodName) {
        Method m15;
        try {
            m15 = c15.getMethod(methodName, null);
        }
        catch (NoSuchMethodException nsme) {
            m15 = null;
        }
        return m15;
    }

    public boolean testAttributeTrue(Object a15) {
        if (a15 == null) {
            return false;
        }
        if (a15 instanceof Boolean) {
            return (Boolean)a15;
        }
        if (a15 instanceof Collection) {
            return ((Collection)a15).size() > 0;
        }
        if (a15 instanceof Map) {
            return ((Map)a15).size() > 0;
        }
        if (a15 instanceof Iterator) {
            return ((Iterator)a15).hasNext();
        }
        return true;
    }

    public Object add(Object a15, Object b15) {
        if (a15 == null) {
            return b15;
        }
        if (b15 == null) {
            return a15;
        }
        return a15.toString() + b15.toString();
    }

    public StringTemplate getTemplateInclude(StringTemplate enclosing, String templateName, StringTemplateAST argumentsAST) {
        StringTemplateGroup group = enclosing.getGroup();
        StringTemplate embedded = group.getEmbeddedInstanceOf(enclosing, templateName);
        if (embedded == null) {
            enclosing.error("cannot make embedded instance of " + templateName + " in template " + enclosing.getName());
            return null;
        }
        embedded.setArgumentsAST(argumentsAST);
        this.evaluateArguments(embedded);
        return embedded;
    }

    public int writeAttribute(StringTemplate self, Object o15, StringTemplateWriter out) {
        return this.write(self, o15, out);
    }

    protected int write(StringTemplate self, Object o15, StringTemplateWriter out) {
        if (o15 == null) {
            if (this.nullValue == null) {
                return -1;
            }
            o15 = this.nullValue;
        }
        int n15 = 0;
        try {
            if (o15 instanceof StringTemplate) {
                return this.writeTemplate(self, o15, out);
            }
            if ((o15 = ASTExpr.convertAnythingIteratableToIterator(o15)) instanceof Iterator) {
                return this.writeIterableValue(self, o15, out);
            }
            return this.writePOJO(self, o15, out);
        }
        catch (IOException io4) {
            self.error("problem writing object: " + o15, io4);
            return n15;
        }
    }

    protected int writePOJO(StringTemplate self, Object o15, StringTemplateWriter out) throws IOException {
        int n15 = 0;
        AttributeRenderer renderer = self.getAttributeRenderer(o15.getClass());
        String v15 = null;
        v15 = renderer != null ? (this.formatString != null ? renderer.toString(o15, this.formatString) : renderer.toString(o15)) : o15.toString();
        n15 = this.wrapString != null ? out.write(v15, this.wrapString) : out.write(v15);
        return n15;
    }

    protected int writeTemplate(StringTemplate self, Object o15, StringTemplateWriter out) throws IOException {
        AttributeRenderer renderer;
        int n15 = 0;
        StringTemplate stToWrite = (StringTemplate)o15;
        stToWrite.setEnclosingInstance(self);
        if (StringTemplate.inLintMode() && StringTemplate.isRecursiveEnclosingInstance(stToWrite)) {
            throw new IllegalStateException("infinite recursion to " + stToWrite.getTemplateDeclaratorString() + " referenced in " + stToWrite.getEnclosingInstance().getTemplateDeclaratorString() + "; stack trace:\n" + stToWrite.getEnclosingInstanceStackTrace());
        }
        if (this.wrapString != null) {
            n15 = out.writeWrapSeparator(this.wrapString);
        }
        if (this.formatString != null && (renderer = self.getAttributeRenderer(String.class)) != null) {
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw4 = self.getGroup().getStringTemplateWriter(buf);
            stToWrite.write(sw4);
            n15 = out.write(renderer.toString(buf.toString(), this.formatString));
            return n15;
        }
        n15 = stToWrite.write(out);
        return n15;
    }

    protected int writeIterableValue(StringTemplate self, Object o15, StringTemplateWriter out) throws IOException {
        int n15 = 0;
        Iterator iter = (Iterator)o15;
        boolean seenAValue = false;
        while (iter.hasNext()) {
            int nw4;
            Object iterValue = iter.next();
            if (iterValue == null) {
                iterValue = this.nullValue;
            }
            if (iterValue == null) continue;
            if (this.separatorString == null) {
                int nw5 = this.write(self, iterValue, out);
                if (nw5 == -1) continue;
                n15 += nw5;
                continue;
            }
            if (iterValue instanceof StringTemplate) {
                StringTemplate st4 = (StringTemplate)iterValue;
                int nchunks = st4.getChunks() != null ? st4.getChunks().size() : 0;
                boolean nullable = true;
                for (int i15 = 0; i15 < nchunks; ++i15) {
                    Expr a15 = (Expr)st4.getChunks().get(i15);
                    if (a15 instanceof ConditionalExpr) continue;
                    nullable = false;
                }
                if (!nullable) {
                    if (seenAValue && this.separatorString != null) {
                        n15 += out.writeSeparator(this.separatorString);
                    }
                    nw4 = this.write(self, iterValue, out);
                    n15 += nw4;
                    seenAValue = true;
                    continue;
                }
            }
            if (!(iterValue instanceof StringTemplate) && !(iterValue instanceof Iterator)) {
                if (seenAValue && this.separatorString != null) {
                    n15 += out.writeSeparator(this.separatorString);
                }
                int nw6 = this.write(self, iterValue, out);
                seenAValue = true;
                n15 += nw6;
                continue;
            }
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw4 = self.getGroup().getStringTemplateWriter(buf);
            int tmpsize = this.write(self, iterValue, sw4);
            if (tmpsize == -1) continue;
            if (seenAValue && this.separatorString != null) {
                n15 += out.writeSeparator(this.separatorString);
            }
            nw4 = this.write(self, iterValue, out);
            n15 += nw4;
            seenAValue = true;
        }
        return n15;
    }

    public String evaluateExpression(StringTemplate self, Object expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof StringTemplateAST) {
            StringTemplateAST exprAST = (StringTemplateAST)expr;
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw4 = self.getGroup().getStringTemplateWriter(buf);
            ActionEvaluator eval = new ActionEvaluator(self, this, sw4);
            try {
                eval.action(exprAST);
            }
            catch (RecognitionException re5) {
                self.error("can't evaluate tree: " + this.exprTree.toStringList(), re5);
            }
            return buf.toString();
        }
        return expr.toString();
    }

    protected void evaluateArguments(StringTemplate self) {
        StringTemplateAST argumentsAST = self.getArgumentsAST();
        if (argumentsAST == null || argumentsAST.getFirstChild() == null) {
            return;
        }
        StringTemplate enclosing = self.getEnclosingInstance();
        StringTemplate argContextST = new StringTemplate(self.getGroup(), "");
        argContextST.setName("<invoke " + self.getName() + " arg context>");
        argContextST.setEnclosingInstance(enclosing);
        argContextST.setArgumentContext(self.getArgumentContext());
        ActionEvaluator eval = new ActionEvaluator(argContextST, this, null);
        try {
            Map ac5 = eval.argList(argumentsAST, self, self.getArgumentContext());
            self.setArgumentContext(ac5);
        }
        catch (RecognitionException re5) {
            self.error("can't evaluate tree: " + argumentsAST.toStringList(), re5);
        }
    }

    public static Object convertArrayToList(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return new ArrayWrappedInList(value);
            }
            return Arrays.asList((Object[])value);
        }
        return value;
    }

    protected static Object convertAnythingIteratableToIterator(Object o15) {
        Iterator iter = null;
        if (o15 instanceof Collection) {
            iter = ((Collection)o15).iterator();
        } else if (o15 instanceof Map) {
            iter = ((Map)o15).values().iterator();
        } else if (o15 instanceof Iterator) {
            iter = (Iterator)o15;
        }
        if (iter == null) {
            return o15;
        }
        return iter;
    }

    protected static Iterator convertAnythingToIterator(Object o15) {
        Iterator iter = null;
        if (o15 instanceof Collection) {
            iter = ((Collection)o15).iterator();
        } else if (o15 instanceof Map) {
            iter = ((Map)o15).values().iterator();
        } else if (o15 instanceof Iterator) {
            iter = (Iterator)o15;
        }
        if (iter == null) {
            StringTemplate.STAttributeList singleton = new StringTemplate.STAttributeList(1);
            singleton.add(o15);
            return singleton.iterator();
        }
        return iter;
    }

    public Object first(Object attribute) {
        Iterator it;
        if (attribute == null) {
            return null;
        }
        Object f15 = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator && (it = (Iterator)attribute).hasNext()) {
            f15 = it.next();
        }
        return f15;
    }

    public Object rest(Object attribute) {
        if (attribute == null) {
            return null;
        }
        Object theRest = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)attribute;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o15 = it.next();
                if (o15 == null) continue;
                a15.add(o15);
            }
            return a15;
        }
        theRest = null;
        return theRest;
    }

    public Object last(Object attribute) {
        if (attribute == null) {
            return null;
        }
        Object last = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object strip(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                Object o15 = it.next();
                if (o15 == null) continue;
                a15.add(o15);
            }
            return a15;
        }
        return attribute;
    }

    public Object trunc(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                Object o15 = it.next();
                if (!it.hasNext()) continue;
                a15.add(o15);
            }
            return a15;
        }
        return null;
    }

    public Object length(Object attribute) {
        if (attribute == null) {
            return new Integer(0);
        }
        int i15 = 1;
        if (attribute instanceof Map) {
            i15 = ((Map)attribute).size();
        } else if (attribute instanceof Collection) {
            i15 = ((Collection)attribute).size();
        } else if (attribute instanceof Object[]) {
            Object[] list2 = (Object[])attribute;
            i15 = list2.length;
        } else if (attribute instanceof int[]) {
            int[] list3 = (int[])attribute;
            i15 = list3.length;
        } else if (attribute instanceof long[]) {
            long[] list4 = (long[])attribute;
            i15 = list4.length;
        } else if (attribute instanceof float[]) {
            float[] list5 = (float[])attribute;
            i15 = list5.length;
        } else if (attribute instanceof double[]) {
            double[] list6 = (double[])attribute;
            i15 = list6.length;
        } else if (attribute instanceof Iterator) {
            Iterator it = (Iterator)attribute;
            i15 = 0;
            while (it.hasNext()) {
                it.next();
                ++i15;
            }
        }
        return new Integer(i15);
    }

    public Object getOption(String name) {
        Object value = null;
        if (this.options != null && (value = this.options.get(name)) == EMPTY_OPTION) {
            return defaultOptionValues.get(name);
        }
        return value;
    }

    public String toString() {
        return this.exprTree.toStringList();
    }
}

