/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.SimilarityScore;

public class LongestCommonSubsequence
implements SimilarityScore<Integer> {
    static final LongestCommonSubsequence INSTANCE = new LongestCommonSubsequence();

    private static int[] algorithmB(CharSequence left, CharSequence right) {
        int m15 = left.length();
        int n15 = right.length();
        int[][] dpRows = new int[2][1 + n15];
        for (int i15 = 1; i15 <= m15; ++i15) {
            int[] temp = dpRows[0];
            dpRows[0] = dpRows[1];
            dpRows[1] = temp;
            for (int j15 = 1; j15 <= n15; ++j15) {
                dpRows[1][j15] = left.charAt(i15 - 1) == right.charAt(j15 - 1) ? dpRows[0][j15 - 1] + 1 : Math.max(dpRows[1][j15 - 1], dpRows[0][j15]);
            }
        }
        return dpRows[1];
    }

    private static String algorithmC(CharSequence left, CharSequence right) {
        int m15 = left.length();
        int n15 = right.length();
        StringBuilder out = new StringBuilder();
        if (m15 == 1) {
            char leftCh = left.charAt(0);
            for (int j15 = 0; j15 < n15; ++j15) {
                if (leftCh != right.charAt(j15)) continue;
                out.append(leftCh);
                break;
            }
        } else if (n15 > 0 && m15 > 1) {
            int mid = m15 / 2;
            CharSequence leftFirstPart = left.subSequence(0, mid);
            CharSequence leftSecondPart = left.subSequence(mid, m15);
            int[] l15 = LongestCommonSubsequence.algorithmB(leftFirstPart, right);
            int[] l25 = LongestCommonSubsequence.algorithmB(LongestCommonSubsequence.reverse(leftSecondPart), LongestCommonSubsequence.reverse(right));
            int k15 = 0;
            int t15 = 0;
            for (int j16 = 0; j16 <= n15; ++j16) {
                int s15 = l15[j16] + l25[n15 - j16];
                if (t15 >= s15) continue;
                t15 = s15;
                k15 = j16;
            }
            out.append(LongestCommonSubsequence.algorithmC(leftFirstPart, right.subSequence(0, k15)));
            out.append(LongestCommonSubsequence.algorithmC(leftSecondPart, right.subSequence(k15, n15)));
        }
        return out.toString();
    }

    private static String reverse(CharSequence s15) {
        return new StringBuilder(s15).reverse().toString();
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        int leftSz = left.length();
        int rightSz = right.length();
        if (leftSz == 0 || rightSz == 0) {
            return 0;
        }
        if (leftSz < rightSz) {
            return LongestCommonSubsequence.algorithmB(right, left)[leftSz];
        }
        return LongestCommonSubsequence.algorithmB(left, right)[rightSz];
    }

    @Deprecated
    public CharSequence logestCommonSubsequence(CharSequence left, CharSequence right) {
        return this.longestCommonSubsequence(left, right);
    }

    public CharSequence longestCommonSubsequence(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        int leftSz = left.length();
        int rightSz = right.length();
        if (leftSz == 0 || rightSz == 0) {
            return "";
        }
        if (leftSz < rightSz) {
            return LongestCommonSubsequence.algorithmC(right, left);
        }
        return LongestCommonSubsequence.algorithmC(left, right);
    }

    @Deprecated
    public int[][] longestCommonSubstringLengthArray(CharSequence left, CharSequence right) {
        int[][] lcsLengthArray = new int[left.length() + 1][right.length() + 1];
        for (int i15 = 0; i15 < left.length(); ++i15) {
            for (int j15 = 0; j15 < right.length(); ++j15) {
                if (i15 == 0) {
                    lcsLengthArray[i15][j15] = 0;
                }
                if (j15 == 0) {
                    lcsLengthArray[i15][j15] = 0;
                }
                lcsLengthArray[i15 + 1][j15 + 1] = left.charAt(i15) == right.charAt(j15) ? lcsLengthArray[i15][j15] + 1 : Math.max(lcsLengthArray[i15 + 1][j15], lcsLengthArray[i15][j15 + 1]);
            }
        }
        return lcsLengthArray;
    }
}

