/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.model;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.AbstractListModel;
import lombok.Generated;
import org.drjekyll.fontchooser.FontFamilies;
import org.drjekyll.fontchooser.FontFamily;

public class FamilyListModel
extends AbstractListModel<String> {
    private static final char[] MONOSPACE_CHARS = new char[]{'0', '1', 'x', 'W'};
    private final FontFamilies fontFamilies = FontFamilies.getInstance();
    private final Component component;
    private List<String> fontFamilyNames;
    private List<String> monospacedFontFamilyNames;
    private boolean monospacedOnly;

    @Override
    public int getSize() {
        this.initialize();
        return (this.monospacedOnly ? this.monospacedFontFamilyNames : this.fontFamilyNames).size();
    }

    @Override
    public String getElementAt(int index) {
        this.initialize();
        return (this.monospacedOnly ? this.monospacedFontFamilyNames : this.fontFamilyNames).get(index);
    }

    public Optional<String> findFirst(CharSequence searchString) {
        this.initialize();
        List<String> families = this.monospacedOnly ? this.monospacedFontFamilyNames : this.fontFamilyNames;
        for (String family : families) {
            if (!family.toLowerCase(Locale.ENGLISH).contains(searchString)) continue;
            return Optional.of(family);
        }
        return Optional.empty();
    }

    private void initialize() {
        if (this.monospacedOnly) {
            if (this.monospacedFontFamilyNames == null) {
                this.monospacedFontFamilyNames = new ArrayList<String>(128);
                for (FontFamily fontFamily : this.fontFamilies) {
                    String name = fontFamily.getName();
                    if (!this.isMonospace(fontFamily)) continue;
                    this.monospacedFontFamilyNames.add(name);
                }
                this.monospacedFontFamilyNames.sort(Comparator.naturalOrder());
            }
        } else if (this.fontFamilyNames == null) {
            this.fontFamilyNames = new ArrayList<String>(this.fontFamilies.size());
            for (FontFamily fontFamily : this.fontFamilies) {
                this.fontFamilyNames.add(fontFamily.getName());
            }
            this.fontFamilyNames.sort(Comparator.naturalOrder());
        }
    }

    private boolean isMonospace(FontFamily fontFamily) {
        FontMetrics metrics = this.component.getFontMetrics(new Font(fontFamily.getName(), 0, 12));
        int width = metrics.charWidth(MONOSPACE_CHARS[0]);
        return width > 1 && IntStream.range(1, MONOSPACE_CHARS.length).noneMatch(i15 -> Math.abs(metrics.charWidth(MONOSPACE_CHARS[i15]) - width) > 2);
    }

    public void setMonospacedOnly(boolean monospacedOnly) {
        this.monospacedOnly = monospacedOnly;
        this.fireContentsChanged(this, -1, -1);
    }

    @Generated
    public FamilyListModel(Component component) {
        this.component = component;
    }
}

