/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;

@ParametersAreNonnullByDefault
public class CodeAreaUtils {
    public static final char[] UPPER_HEX_CODES = "0123456789ABCDEF".toCharArray();
    public static final char[] LOWER_HEX_CODES = "0123456789abcdef".toCharArray();
    private static final int CODE_BUFFER_LENGTH = 16;
    public static final String MIME_CLIPBOARD_BINARY = "application/octet-stream";
    public static final String BINED_CLIPBOARD_MIME = "application/x-bined";
    public static final String BINED_CLIPBOARD_MIME_FULL = "application/x-bined; class=" + BinaryData.class.getCanonicalName();
    public static final String CONTENT_DATA_ERROR = "Content data is null";
    public static final String NULL_FIELD_ERROR = "Field cannot be null";

    private CodeAreaUtils() {
    }

    @Nonnull
    public static char[] byteToHexChars(byte value) {
        char[] result = new char[2];
        CodeAreaUtils.byteToHexChars(result, value);
        return result;
    }

    public static void byteToHexChars(char[] target, byte value) {
        target[0] = UPPER_HEX_CODES[value >> 4 & 0xF];
        target[1] = UPPER_HEX_CODES[value & 0xF];
    }

    @Nonnull
    public static char[] longToHexChars(long value, int length) {
        char[] result = new char[length];
        CodeAreaUtils.longToHexChars(result, value, length);
        return result;
    }

    public static void longToHexChars(char[] target, long value, int length) {
        for (int i15 = length - 1; i15 >= 0; --i15) {
            target[i15] = UPPER_HEX_CODES[(int)(value & 0xFL)];
            value >>= 4;
        }
    }

    public static void byteToCharsCode(byte dataByte, CodeType codeType, char[] targetData, int targetPosition, CodeCharactersCase charCase) {
        char[] hexCharacters = charCase == CodeCharactersCase.UPPER ? UPPER_HEX_CODES : LOWER_HEX_CODES;
        switch (codeType) {
            case BINARY: {
                int bitMask = 128;
                for (int i15 = 0; i15 < 8; ++i15) {
                    int codeValue = (dataByte & bitMask) > 0 ? 1 : 0;
                    targetData[targetPosition + i15] = hexCharacters[codeValue];
                    bitMask >>= 1;
                }
                break;
            }
            case DECIMAL: {
                int value = dataByte & 0xFF;
                int codeValue0 = value / 100;
                targetData[targetPosition] = hexCharacters[codeValue0];
                int codeValue1 = value / 10 % 10;
                targetData[targetPosition + 1] = hexCharacters[codeValue1];
                int codeValue2 = value % 10;
                targetData[targetPosition + 2] = hexCharacters[codeValue2];
                break;
            }
            case OCTAL: {
                int value = dataByte & 0xFF;
                int codeValue0 = value / 64;
                targetData[targetPosition] = hexCharacters[codeValue0];
                int codeValue1 = value / 8 & 7;
                targetData[targetPosition + 1] = hexCharacters[codeValue1];
                int codeValue2 = value % 8;
                targetData[targetPosition + 2] = hexCharacters[codeValue2];
                break;
            }
            case HEXADECIMAL: {
                int codeValue0 = dataByte >> 4 & 0xF;
                targetData[targetPosition] = hexCharacters[codeValue0];
                int codeValue1 = dataByte & 0xF;
                targetData[targetPosition + 1] = hexCharacters[codeValue1];
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(codeType);
            }
        }
    }

    public static byte stringCodeToByte(String code, CodeType codeType) {
        if (code.length() > codeType.getMaxDigitsForByte()) {
            throw new IllegalArgumentException("String code is too long");
        }
        byte result = 0;
        switch (codeType) {
            case BINARY: {
                int bitMask = 1;
                for (int i15 = code.length() - 1; i15 >= 0; --i15) {
                    switch (code.charAt(i15)) {
                        case '0': {
                            break;
                        }
                        case '1': {
                            result = (byte)(result | bitMask);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid character " + code.charAt(i15));
                        }
                    }
                    bitMask <<= 1;
                }
                break;
            }
            case OCTAL: {
                int bitMask = 1;
                int resultInt = 0;
                for (int i16 = code.length() - 1; i16 >= 0; --i16) {
                    char codeChar = code.charAt(i16);
                    if (codeChar >= '0' && codeChar <= '7') {
                        resultInt += bitMask * (codeChar - 48);
                    } else {
                        throw new IllegalArgumentException("Invalid character " + codeChar);
                    }
                    bitMask <<= 3;
                }
                if (resultInt > 255) {
                    throw new IllegalArgumentException("Number is too big " + resultInt);
                }
                result = (byte)resultInt;
                break;
            }
            case DECIMAL: {
                int bitMask = 1;
                int resultInt = 0;
                for (int i17 = code.length() - 1; i17 >= 0; --i17) {
                    char codeChar = code.charAt(i17);
                    if (codeChar >= '0' && codeChar <= '9') {
                        resultInt += bitMask * (codeChar - 48);
                    } else {
                        throw new IllegalArgumentException("Invalid character " + codeChar);
                    }
                    bitMask *= 10;
                }
                if (resultInt > 255) {
                    throw new IllegalArgumentException("Number is too big " + resultInt);
                }
                result = (byte)resultInt;
                break;
            }
            case HEXADECIMAL: {
                int bitMask = 1;
                for (int i18 = code.length() - 1; i18 >= 0; --i18) {
                    char codeChar = code.charAt(i18);
                    if (codeChar >= '0' && codeChar <= '9') {
                        result = (byte)(result | (byte)(bitMask * (codeChar - 48)));
                    } else if (codeChar >= 'a' && codeChar <= 'f') {
                        result = (byte)(result | (byte)(bitMask * (codeChar + 10 - 97)));
                    } else if (codeChar >= 'A' && codeChar <= 'F') {
                        result = (byte)(result | (byte)(bitMask * (codeChar + 10 - 65)));
                    } else {
                        throw new IllegalArgumentException("Invalid character " + codeChar);
                    }
                    bitMask <<= 4;
                }
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(codeType);
            }
        }
        return result;
    }

    public static int longToBaseCode(char[] target, int targetOffset, long value, int base, int lengthLimit, boolean fillZeros, CodeCharactersCase characterCase) {
        char[] codes = characterCase == CodeCharactersCase.UPPER ? UPPER_HEX_CODES : LOWER_HEX_CODES;
        for (int i15 = lengthLimit - 1; i15 >= 0; --i15) {
            target[targetOffset + i15] = codes[(int)(value % (long)base)];
            if (fillZeros || (value /= (long)base) != 0L) continue;
            return i15;
        }
        return 0;
    }

    @Nonnull
    public static byte[] characterToBytes(char value, Charset charset) {
        ByteBuffer buffer = charset.encode(Character.toString(value));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    public static void insertHexStringIntoData(String insertedString, EditableBinaryData data, CodeType codeType) {
        int maxDigits = codeType.getMaxDigitsForByte();
        byte[] buffer = new byte[16];
        int bufferUsage = 0;
        int offset = 0;
        for (int i15 = 0; i15 < insertedString.length(); ++i15) {
            byte value;
            char charAt = insertedString.charAt(i15);
            if ((charAt == ' ' || charAt == '\t') && offset == i15) {
                ++offset;
            } else if (charAt == ' ' || charAt == '\t' || charAt == ',' || charAt == ';' || charAt == ':') {
                buffer[bufferUsage] = value = CodeAreaUtils.stringCodeToByte(insertedString.substring(offset, i15), codeType);
                ++bufferUsage;
                offset = i15 + 1;
            } else if (i15 == offset + maxDigits) {
                buffer[bufferUsage] = value = CodeAreaUtils.stringCodeToByte(insertedString.substring(offset, i15), codeType);
                ++bufferUsage;
                offset = i15;
            }
            if (bufferUsage != 16) continue;
            data.insert(data.getDataSize(), buffer, 0, bufferUsage);
            bufferUsage = 0;
        }
        if (offset < insertedString.length()) {
            byte value;
            buffer[bufferUsage] = value = CodeAreaUtils.stringCodeToByte(insertedString.substring(offset), codeType);
            ++bufferUsage;
        }
        if (bufferUsage > 0) {
            data.insert(data.getDataSize(), buffer, 0, bufferUsage);
        }
    }

    public static boolean isValidCodeKeyValue(char keyValue, int codeOffset, CodeType codeType) {
        boolean validKey = false;
        switch (codeType) {
            case BINARY: {
                validKey = keyValue >= '0' && keyValue <= '1';
                break;
            }
            case DECIMAL: {
                validKey = codeOffset == 0 ? keyValue >= '0' && keyValue <= '2' : keyValue >= '0' && keyValue <= '9';
                break;
            }
            case OCTAL: {
                validKey = codeOffset == 0 ? keyValue >= '0' && keyValue <= '3' : keyValue >= '0' && keyValue <= '7';
                break;
            }
            case HEXADECIMAL: {
                validKey = keyValue >= '0' && keyValue <= '9' || keyValue >= 'a' && keyValue <= 'f' || keyValue >= 'A' && keyValue <= 'F';
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(codeType);
            }
        }
        return validKey;
    }

    public static byte setCodeValue(byte byteValue, int value, int codeOffset, CodeType codeType) {
        switch (codeType) {
            case BINARY: {
                int bitMask = 128 >> codeOffset;
                byteValue = (byte)(byteValue & 255 - bitMask | value << 7 - codeOffset);
                break;
            }
            case DECIMAL: {
                int newValue = byteValue & 0xFF;
                switch (codeOffset) {
                    case 0: {
                        newValue = newValue % 100 + value * 100;
                        if (newValue <= 255) break;
                        newValue = 200;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 100 * 100 + value * 10 + newValue % 10;
                        if (newValue <= 255) break;
                        newValue -= 200;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 10 * 10 + value;
                        if (newValue <= 255) break;
                        newValue -= 200;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case OCTAL: {
                int newValue = byteValue & 0xFF;
                switch (codeOffset) {
                    case 0: {
                        newValue = newValue % 64 + value * 64;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 64 * 64 + value * 8 + newValue % 8;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 8 * 8 + value;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case HEXADECIMAL: {
                if (codeOffset == 1) {
                    byteValue = (byte)(byteValue & 0xF0 | value);
                    break;
                }
                byteValue = (byte)(byteValue & 0xF | value << 4);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(codeType);
            }
        }
        return byteValue;
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T object) {
        return Objects.requireNonNull(object, NULL_FIELD_ERROR);
    }

    @Nonnull
    public static <T> T requireNonNull(@Nullable T object, String message2) {
        return Objects.requireNonNull(object, message2);
    }

    public static void requireNonNull(Object ... objects) {
        for (Object object : objects) {
            Objects.requireNonNull(object, NULL_FIELD_ERROR);
        }
    }

    @Nonnull
    public static <T> T requireNonNullContentData(@Nullable T object) {
        return Objects.requireNonNull(object, CONTENT_DATA_ERROR);
    }

    public static void throwInvalidTypeException(Enum<?> enumObject) {
        throw CodeAreaUtils.getInvalidTypeException(enumObject);
    }

    @Nonnull
    public static IllegalStateException getInvalidTypeException(Enum<?> enumObject) {
        return new IllegalStateException("Unexpected " + enumObject.getDeclaringClass().getName() + " value " + enumObject.name());
    }
}

