/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section.diff;

import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPaintState;

@ParametersAreNonnullByDefault
public class DiffHighlightCodeAreaColorAssessor
implements CodeAreaColorAssessor {
    protected CodeAreaColorAssessor parentAssessor;
    protected BinaryData comparedData;
    protected Color diffColor;
    protected Color addedColor;
    protected CodeAreaCore codeArea;
    protected long dataSize;

    public DiffHighlightCodeAreaColorAssessor(CodeAreaCore codeArea, @Nullable CodeAreaColorAssessor parentColorAssessor, @Nullable BinaryData comparedData) {
        this.codeArea = codeArea;
        this.parentAssessor = parentColorAssessor;
        this.comparedData = comparedData;
        this.diffColor = new Color(255, 180, 180);
        this.addedColor = new Color(180, 255, 180);
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPainterState) {
        this.dataSize = codeAreaPainterState.getDataSize();
        if (this.parentAssessor != null) {
            this.parentAssessor.startPaint(codeAreaPainterState);
        }
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        byte comparedByte;
        byte sourceByte;
        long position = rowDataPosition + (long)byteOnRow;
        if (this.comparedData != null && position >= this.comparedData.getDataSize()) {
            return this.addedColor;
        }
        if (this.comparedData != null && position < this.dataSize && position < this.comparedData.getDataSize() && (sourceByte = this.codeArea.getContentData().getByte(position)) != (comparedByte = this.comparedData.getByte(position))) {
            return this.diffColor;
        }
        if (this.parentAssessor != null) {
            return this.parentAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (this.parentAssessor != null) {
            return this.parentAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentAssessor);
    }

    public void setComparedData(BinaryData comparedData) {
        this.comparedData = comparedData;
        this.codeArea.notifyDataChanged();
    }

    @Nonnull
    public Color getDiffColor() {
        return this.diffColor;
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }
}

