/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.ibatis.ognl.AccessibleObjectHandler;
import org.apache.ibatis.ognl.AccessibleObjectHandlerPreJDK9;
import org.apache.ibatis.ognl.OgnlRuntime;

class AccessibleObjectHandlerJDK9Plus
implements AccessibleObjectHandler {
    private static final Class<?> CLAZZ_UNSAFE = AccessibleObjectHandlerJDK9Plus.instantiateClazzUnsafe();
    private static final Object UNSAFE_INSTANCE = AccessibleObjectHandlerJDK9Plus.instantiateUnsafeInstance();
    private static final Method UNSAFE_OBJECT_FIELD_OFFSET_METHOD = AccessibleObjectHandlerJDK9Plus.instantiateUnsafeObjectFieldOffsetMethod();
    private static final Method UNSAFE_PUT_BOOLEAN_METHOD = AccessibleObjectHandlerJDK9Plus.instantiateUnsafePutBooleanMethod();
    private static final Field ACCESSIBLE_OBJECT_OVERRIDE_FIELD = AccessibleObjectHandlerJDK9Plus.instantiateAccessibleObjectOverrideField();
    private static final long ACCESSIBLE_OBJECT_OVERRIDE_FIELD_OFFSET = AccessibleObjectHandlerJDK9Plus.determineAccessibleObjectOverrideFieldOffset();

    private AccessibleObjectHandlerJDK9Plus() {
    }

    static boolean unsafeOrDescendant(Class<?> clazz) {
        return CLAZZ_UNSAFE != null && CLAZZ_UNSAFE.isAssignableFrom(clazz);
    }

    private static Class<?> instantiateClazzUnsafe() {
        Class<?> clazz;
        try {
            clazz = Class.forName("sun.misc.Unsafe");
        }
        catch (Throwable t) {
            clazz = null;
        }
        return clazz;
    }

    private static Object instantiateUnsafeInstance() {
        Object unsafe;
        if (CLAZZ_UNSAFE != null) {
            Field field = null;
            try {
                field = CLAZZ_UNSAFE.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = field.get(null);
            }
            catch (Throwable t) {
                unsafe = null;
            }
            finally {
                if (field != null) {
                    try {
                        field.setAccessible(false);
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else {
            unsafe = null;
        }
        return unsafe;
    }

    private static Method instantiateUnsafeObjectFieldOffsetMethod() {
        Method method;
        if (CLAZZ_UNSAFE != null) {
            try {
                method = CLAZZ_UNSAFE.getMethod("objectFieldOffset", Field.class);
            }
            catch (Throwable t) {
                method = null;
            }
        } else {
            method = null;
        }
        return method;
    }

    private static Method instantiateUnsafePutBooleanMethod() {
        Method method;
        if (CLAZZ_UNSAFE != null) {
            try {
                method = CLAZZ_UNSAFE.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            }
            catch (Throwable t) {
                method = null;
            }
        } else {
            method = null;
        }
        return method;
    }

    private static Field instantiateAccessibleObjectOverrideField() {
        Field field;
        try {
            field = AccessibleObject.class.getDeclaredField("override");
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }

    private static long determineAccessibleObjectOverrideFieldOffset() {
        long offset = -1L;
        if (ACCESSIBLE_OBJECT_OVERRIDE_FIELD != null && UNSAFE_OBJECT_FIELD_OFFSET_METHOD != null && UNSAFE_INSTANCE != null) {
            try {
                offset = (Long)UNSAFE_OBJECT_FIELD_OFFSET_METHOD.invoke(UNSAFE_INSTANCE, ACCESSIBLE_OBJECT_OVERRIDE_FIELD);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return offset;
    }

    static AccessibleObjectHandler createHandler() {
        if (OgnlRuntime.usingJDK9PlusAccessHandler()) {
            return new AccessibleObjectHandlerJDK9Plus();
        }
        return AccessibleObjectHandlerPreJDK9.createHandler();
    }

    @Override
    public void setAccessible(AccessibleObject accessibleObject, boolean flag) {
        boolean operationComplete = false;
        if (UNSAFE_INSTANCE != null && UNSAFE_PUT_BOOLEAN_METHOD != null && ACCESSIBLE_OBJECT_OVERRIDE_FIELD_OFFSET != -1L) {
            try {
                UNSAFE_PUT_BOOLEAN_METHOD.invoke(UNSAFE_INSTANCE, accessibleObject, ACCESSIBLE_OBJECT_OVERRIDE_FIELD_OFFSET, flag);
                operationComplete = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!operationComplete) {
            accessibleObject.setAccessible(flag);
        }
    }
}

