/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.IndexData;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

abstract class IndexConverterHelper
extends ConverterHelper {
    private String sSourceName;
    private List<IndexData> indexes = new ArrayList<IndexData>();

    IndexConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter, String sSourceName) {
        super(ofr, config, converter);
        this.sSourceName = sSourceName;
    }

    abstract void generate(IndexData var1);

    void generate() {
        int nSaveOutFileIndex = this.converter.getOutFileIndex();
        int nIndexCount = this.indexes.size();
        for (int i = 0; i < nIndexCount; ++i) {
            this.converter.changeOutFile(this.indexes.get((int)i).nOutFileIndex);
            this.generate(this.indexes.get(i));
        }
        this.converter.changeOutFile(nSaveOutFileIndex);
    }

    void handleIndex(Element onode, Element hnode, int nChapterNumber) {
        Element source = Misc.getChildByTagName(onode, this.sSourceName);
        if (source != null) {
            Element container = this.createContainer(onode, hnode);
            this.convertTitle(source, container);
            this.convertContent(source, container, nChapterNumber);
        }
    }

    private Element createContainer(Element source, Element hnode) {
        String sStyleName;
        Element container = this.converter.createAlternativeElement("section", "div");
        hnode.appendChild(container);
        String sName = source.getAttribute("text:name");
        if (sName != null) {
            this.converter.addTarget(container, sName);
        }
        if ((sStyleName = source.getAttribute("text:style-name")) != null) {
            StyleInfo sectionInfo = new StyleInfo();
            this.getSectionSc().applyStyle(sStyleName, sectionInfo);
            this.applyStyle(sectionInfo, container);
        }
        return container;
    }

    private void convertTitle(Element source, Element container) {
        Element title = Misc.getChildByTagName(source, "text:index-title-template");
        if (title != null) {
            Element h1 = this.converter.createElement("h1");
            container.appendChild(h1);
            String sStyleName = Misc.getAttribute((Node)title, "text:style-name");
            StyleInfo info = new StyleInfo();
            info.sTagName = "h1";
            this.getHeadingSc().applyStyle(1, sStyleName, info);
            this.applyStyle(info, h1);
            this.getTextCv().traversePCDATA(title, h1);
        }
    }

    private void convertContent(Element source, Element container, int nChapterNumber) {
        Element ul = this.converter.createElement("ul");
        ul.setAttribute("style", "list-style-type:none;margin:0;padding:0");
        container.appendChild(ul);
        IndexData data = new IndexData();
        data.nOutFileIndex = this.converter.getOutFileIndex();
        data.onode = source;
        data.nChapterNumber = nChapterNumber;
        data.hnode = ul;
        this.indexes.add(data);
    }
}

